package org.eclipse.hyades.logging.java;

import java.util.logging.Level;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Extension of the Java Logging <code>java.util.logging.Level</code>
 * class used to create customized levels.
 * <p>
 * Users requiring logging levels not provided in the Java Logging 
 * <code>java.util.logging.Level</code> class should create a 
 * <code>org.eclipse.hyades.logging.java</code> using one of its constructors,
 * passing a symbolic name and associated numerical value for the newly
 * defined level.
 * <p>
 * Convenience static level objects are <b>not</b> provided by this 
 * extension class.  Application code leveraging this class should provide 
 * convenience static level objects relative to run-time logging instrumentation.
 * <p>
 * NOTE: The Java Logging classes must be on the CLASSPATH at run-time to
 * utilize this level class.
 * <p>
 *  
 * 
 * @author  Paul Slauenwhite
 * @version July 21, 2004
 * @since   April 15, 2004
 * @see     java.util.logging.Level
 */
public class CommonBaseEventLevel extends Level {

    /**
     * Two parameter constructor for creating a customized level with a
     * symbolic name and associated numerical value.
     * <p>
     * 
     * @param name  The symbolic name of the newly defined level.
     * @param value The associated numerical value of the newly defined level.
     */
    public CommonBaseEventLevel(String name, int value){
        super(name,value);
    }

    /**
     * Three parameter constructor for creating a customized level with a
     * localized symbolic name and associated numerical value.
     * <p>
     * 
     * @param name  The key into the resource bundle to retrieve the symbolic name of the newly defined level.
     * @param value The associated numerical value of the newly defined level.
     * @param resourceBundleName The name of a local resource bundle to localize the newly defined level's name, otherwise null.
     */
    public CommonBaseEventLevel(String name, int value, String resourceBundleName){
        super(name,value,resourceBundleName);
    }
}
