package org.eclipse.hyades.logging.java.tests;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;
import org.eclipse.hyades.logging.java.XmlFormatter;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * All JUnit test cases for the
 * <code>org.eclipse.hyades.logging.java.XmlFormatter</code>
 * class.
 * <p>
 * 
 * @author  Paul E. Slauenwhite
 * @version October 27, 2004
 * @since   October 27, 2004
 */
public class XmlFormatterTest extends TestCase {

    private EventFactory eventFactory = null;

    /**
     * Private static reference to the platform-dependent line separator character.
     */
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
   
    /**
     * Constructor for CommonBaseEventLogRecordTest.
     * <p>
     * 
     * @param name
     *            The name of the test case.
     */
    public XmlFormatterTest(String name) {
        super(name);
    }

    /**
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {

        super.setUp();

        eventFactory = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
    }

    /**
     * Tests formatting a Common Base Event Log Record.
     */
    public void testXmlFormattingCommonBaseEventLogRecord() {

        try {
            
            LogRecord tempLogRecord = new LogRecord(Level.OFF, null);

            final long SEQUENCE_NUMBER = (tempLogRecord.getSequenceNumber() + 1);

            final int THREAD_ID = tempLogRecord.getThreadID();

            final long CURRENT_TIME = System.currentTimeMillis();

            final String LOGGER_NAME = "Logger Name";

            final String MESSAGE = "Message";

            final String[] PARAMETERS = new String[] { "Paramater1", "Paramater2", "Paramater3"};

            final ResourceBundle RESOURCE_BUNDLE = new ResourceBundle() {

                public Enumeration getKeys() {
                    return null;
                }

                public Locale getLocale() {
                    return null;
                }

                protected Object handleGetObject(String key) {
                    return null;
                }

                protected void setParent(ResourceBundle parent) {
                }
            };

            final String RESOURCE_BUNDLE_NAME = "ResourceBundleName";

            final String SOURCE_CLASS_NAME = "Source Class Name";

            final String SOURCE_METHOD_NAME = "Source Method Name";

            final int THROWABLES_LEVELS = 100;

            Throwable throwable = null;
            Throwable child = new Throwable("ChildThrowable" + THROWABLES_LEVELS);

            for (int counter = (THROWABLES_LEVELS - 1); counter > 0; counter--) {

                throwable = new Throwable("ChildThrowable" + counter, child);
                child = throwable;
            }

            throwable = new Throwable("Throwable", child);

            CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();

            CommonBaseEventLogRecord commonBaseEventLogRecord = new CommonBaseEventLogRecord(commonBaseEvent);

            commonBaseEventLogRecord.setSequenceNumber(SEQUENCE_NUMBER);

            commonBaseEventLogRecord.setThreadID(THREAD_ID);

            commonBaseEventLogRecord.setMillis(CURRENT_TIME);

            commonBaseEventLogRecord.setLevel(Level.ALL);

            commonBaseEventLogRecord.setLoggerName(LOGGER_NAME);

            commonBaseEventLogRecord.setMessage(MESSAGE);
        
            commonBaseEventLogRecord.setParameters(PARAMETERS);

            commonBaseEventLogRecord.setResourceBundleName(RESOURCE_BUNDLE_NAME);

            commonBaseEventLogRecord.setResourceBundle(RESOURCE_BUNDLE);

            commonBaseEventLogRecord.setSourceClassName(SOURCE_CLASS_NAME);

            commonBaseEventLogRecord.setSourceMethodName(SOURCE_METHOD_NAME);

            commonBaseEventLogRecord.setThrown(throwable);

            String commonBaseEventXML = EventFormatter.toCanonicalXMLString(commonBaseEventLogRecord.getCommonBaseEvent(), true).concat(LINE_SEPARATOR);

            String formattedCommonBaseEventXML = new XmlFormatter().format(commonBaseEventLogRecord);
            
            assertEquals(commonBaseEventXML,formattedCommonBaseEventXML);
        } 
        catch (AssertionFailedError a) {
            throw (a);
        } 
        catch (Throwable t) {
            assertTrue(t.toString(), false);
        }
    }

    /**
     * Tests formatting a Log Record.
     */
    public void testXmlFormattingLogRecord() {
        try {
            
            LogRecord tempLogRecord = new LogRecord(Level.OFF, null);

            final long SEQUENCE_NUMBER = (tempLogRecord.getSequenceNumber() + 1);

            final int THREAD_ID = tempLogRecord.getThreadID();

            final long CURRENT_TIME = System.currentTimeMillis();

            final String LOGGER_NAME = "Logger Name";

            final String MESSAGE = "Message";

            final String[] PARAMETERS = new String[] { "Paramater1", "Paramater2", "Paramater3"};

            final ResourceBundle RESOURCE_BUNDLE = new ResourceBundle() {

                public Enumeration getKeys() {
                    return null;
                }

                public Locale getLocale() {
                    return null;
                }

                protected Object handleGetObject(String key) {
                    return null;
                }

                protected void setParent(ResourceBundle parent) {
                }
            };

            final String RESOURCE_BUNDLE_NAME = "ResourceBundleName";

            final String SOURCE_CLASS_NAME = "Source Class Name";

            final String SOURCE_METHOD_NAME = "Source Method Name";

            final int THROWABLES_LEVELS = 100;

            Throwable throwable = null;
            Throwable child = new Throwable("ChildThrowable" + THROWABLES_LEVELS);

            for (int counter = (THROWABLES_LEVELS - 1); counter > 0; counter--) {

                throwable = new Throwable("ChildThrowable" + counter, child);
                child = throwable;
            }

            throwable = new Throwable("Throwable", child);

            CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();

            CommonBaseEventLogRecord commonBaseEventLogRecord = new CommonBaseEventLogRecord(commonBaseEvent);

            commonBaseEventLogRecord.setSequenceNumber(SEQUENCE_NUMBER);

            commonBaseEventLogRecord.setThreadID(THREAD_ID);

            commonBaseEventLogRecord.setMillis(CURRENT_TIME);

            commonBaseEventLogRecord.setLevel(Level.ALL);

            commonBaseEventLogRecord.setLoggerName(LOGGER_NAME);

            commonBaseEventLogRecord.setMessage(MESSAGE);
        
            commonBaseEventLogRecord.setParameters(PARAMETERS);

            commonBaseEventLogRecord.setResourceBundleName(RESOURCE_BUNDLE_NAME);

            commonBaseEventLogRecord.setResourceBundle(RESOURCE_BUNDLE);

            commonBaseEventLogRecord.setSourceClassName(SOURCE_CLASS_NAME);

            commonBaseEventLogRecord.setSourceMethodName(SOURCE_METHOD_NAME);

            commonBaseEventLogRecord.setThrown(throwable);

            LogRecord logRecord = new LogRecord(Level.ALL,MESSAGE);

            logRecord.setMillis(CURRENT_TIME);

            logRecord.setLoggerName(LOGGER_NAME);

            logRecord.setSequenceNumber(SEQUENCE_NUMBER);

            logRecord.setParameters(PARAMETERS);

            logRecord.setResourceBundle(RESOURCE_BUNDLE);

            logRecord.setResourceBundleName(RESOURCE_BUNDLE_NAME);

            logRecord.setSourceClassName(SOURCE_CLASS_NAME);

            logRecord.setSourceMethodName(SOURCE_METHOD_NAME);

            logRecord.setThreadID(THREAD_ID);
            
            logRecord.setThrown(throwable);

            String commonBaseEventXML = EventFormatter.toCanonicalXMLString(commonBaseEventLogRecord.getCommonBaseEvent(), true).concat(LINE_SEPARATOR);

            String formattedLogRecordXML = new XmlFormatter().format(logRecord);
            
            assertEquals(commonBaseEventXML,formattedLogRecordXML);
        } 
        catch (AssertionFailedError a) {
            throw (a);
        } 
        catch (Throwable t) {
            assertTrue(t.toString(), false);
        }
    }  
}