/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.internal.codegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMNode;

/**
 * Based on the EMF GenBaseImpl implementation
 * @author marcelop
 * @since 1.0.1
 */
public class ImportManager
{
	protected static HashSet javaReservedWords;

	protected static HashSet javaLangTypes;

	/**
	 * Returns a hash of all Java's keywords and textual literals, as of Java
	 * 1.4.
	 */
	public static HashSet getJavaReservedWords()
	{
		if (javaReservedWords == null)
		{
			javaReservedWords = new HashSet(100);
			javaReservedWords.add("abstract");
			javaReservedWords.add("assert");
			javaReservedWords.add("boolean");
			javaReservedWords.add("break");
			javaReservedWords.add("byte");
			javaReservedWords.add("case");
			javaReservedWords.add("catch");
			javaReservedWords.add("char");
			javaReservedWords.add("class");
			javaReservedWords.add("const");
			javaReservedWords.add("continue");
			javaReservedWords.add("default");
			javaReservedWords.add("do");
			javaReservedWords.add("double");
			javaReservedWords.add("else");
			javaReservedWords.add("extends");
			javaReservedWords.add("false");
			javaReservedWords.add("final");
			javaReservedWords.add("finally");
			javaReservedWords.add("float");
			javaReservedWords.add("for");
			javaReservedWords.add("goto");
			javaReservedWords.add("if");
			javaReservedWords.add("implements");
			javaReservedWords.add("import");
			javaReservedWords.add("instanceof");
			javaReservedWords.add("int");
			javaReservedWords.add("interface");
			javaReservedWords.add("long");
			javaReservedWords.add("native");
			javaReservedWords.add("new");
			javaReservedWords.add("null");
			javaReservedWords.add("package");
			javaReservedWords.add("private");
			javaReservedWords.add("protected");
			javaReservedWords.add("public");
			javaReservedWords.add("return");
			javaReservedWords.add("short");
			javaReservedWords.add("static");
			javaReservedWords.add("strictfp");
			javaReservedWords.add("super");
			javaReservedWords.add("switch");
			javaReservedWords.add("synchronized");
			javaReservedWords.add("this");
			javaReservedWords.add("throw");
			javaReservedWords.add("throws");
			javaReservedWords.add("transient");
			javaReservedWords.add("true");
			javaReservedWords.add("try");
			javaReservedWords.add("void");
			javaReservedWords.add("volatile");
			javaReservedWords.add("while");
		}
		return javaReservedWords;
	}

	public static HashSet getJavaLangTypes()
	{
		if (javaLangTypes == null)
		{
			javaLangTypes = new HashSet(100);
			javaLangTypes.add("AbstractMethodError");
			javaLangTypes.add("ArithmeticException");
			javaLangTypes.add("ArrayIndexOutOfBoundsException");
			javaLangTypes.add("ArrayStoreException");
			javaLangTypes.add("Boolean");
			javaLangTypes.add("Byte");
			javaLangTypes.add("Character");
			javaLangTypes.add("Class");
			javaLangTypes.add("ClassCastException");
			javaLangTypes.add("ClassCircularityError");
			javaLangTypes.add("ClassFormatError");
			javaLangTypes.add("ClassLoader");
			javaLangTypes.add("ClassNotFoundException");
			javaLangTypes.add("CloneNotSupportedException");
			javaLangTypes.add("Cloneable");
			javaLangTypes.add("Comparable");
			javaLangTypes.add("Compiler");
			javaLangTypes.add("Double");
			javaLangTypes.add("Error");
			javaLangTypes.add("Exception");
			javaLangTypes.add("ExceptionInInitializerError");
			javaLangTypes.add("Float");
			javaLangTypes.add("FloatingDecimal");
			javaLangTypes.add("IllegalAccessError");
			javaLangTypes.add("IllegalAccessException");
			javaLangTypes.add("IllegalArgumentException");
			javaLangTypes.add("IllegalMonitorStateException");
			javaLangTypes.add("IllegalStateException");
			javaLangTypes.add("IllegalThreadStateException");
			javaLangTypes.add("IncompatibleClassChangeError");
			javaLangTypes.add("IndexOutOfBoundsException");
			javaLangTypes.add("InheritableThreadLocal");
			javaLangTypes.add("InstantiationError");
			javaLangTypes.add("InstantiationException");
			javaLangTypes.add("Integer");
			javaLangTypes.add("InternalError");
			javaLangTypes.add("InterruptedException");
			javaLangTypes.add("LinkageError");
			javaLangTypes.add("Long");
			javaLangTypes.add("Math");
			javaLangTypes.add("NegativeArraySizeException");
			javaLangTypes.add("NoClassDefFoundError");
			javaLangTypes.add("NoSuchFieldError");
			javaLangTypes.add("NoSuchFieldException");
			javaLangTypes.add("NoSuchMethodError");
			javaLangTypes.add("NoSuchMethodException");
			javaLangTypes.add("NullPointerException");
			javaLangTypes.add("Number");
			javaLangTypes.add("NumberFormatException");
			javaLangTypes.add("Object");
			javaLangTypes.add("OutOfMemoryError");
			javaLangTypes.add("Package");
			javaLangTypes.add("Process");
			javaLangTypes.add("Runnable");
			javaLangTypes.add("Runtime");
			javaLangTypes.add("RuntimeException");
			javaLangTypes.add("RuntimePermission");
			javaLangTypes.add("SecurityException");
			javaLangTypes.add("SecurityManager");
			javaLangTypes.add("Short");
			javaLangTypes.add("StackOverflowError");
			javaLangTypes.add("String");
			javaLangTypes.add("StringBuffer");
			javaLangTypes.add("StringIndexOutOfBoundsException");
			javaLangTypes.add("System");
			javaLangTypes.add("Thread");
			javaLangTypes.add("ThreadDeath");
			javaLangTypes.add("ThreadGroup");
			javaLangTypes.add("ThreadLocal");
			javaLangTypes.add("Throwable");
			javaLangTypes.add("UnknownError");
			javaLangTypes.add("UnsatisfiedLinkError");
			javaLangTypes.add("UnsupportedClassVersionError");
			javaLangTypes.add("UnsupportedOperationException");
			javaLangTypes.add("VerifyError");
			javaLangTypes.add("VirtualMachineError");
			javaLangTypes.add("Void");
			javaLangTypes.add("boolean");
			javaLangTypes.add("byte");
			javaLangTypes.add("char");
			javaLangTypes.add("double");
			javaLangTypes.add("float");
			javaLangTypes.add("int");
			javaLangTypes.add("long");
			javaLangTypes.add("short");
		}
		return javaLangTypes;
	}

	protected SortedSet imports = new TreeSet();
	protected HashMap shortNameToImportMap = new HashMap();
	protected HashSet javaLangImports = null;
	protected HashSet importedPackages;

	public ImportManager(String compilationUnitPackage)
	{
		importedPackages = new HashSet();
		importedPackages.add(compilationUnitPackage);
	}

	public Collection getImports()
	{
		return imports;
	}

	public String getImportedName(String qualifiedName)
	{
		String indices = "";
		int firstBracket = qualifiedName.indexOf("[");
		if (firstBracket != -1)
		{
			indices = qualifiedName.substring(firstBracket);
			qualifiedName = qualifiedName.substring(0, firstBracket);
		}

		String baseName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);

		String shortName = baseName;
		int firstDollar = shortName.indexOf("$");
		if (firstDollar != -1)
		{
			shortName = shortName.substring(0, firstDollar);
		}

		String registeredName = (String)shortNameToImportMap.get(shortName);
		if (registeredName == null)
		{
			registeredName = "java.lang." + shortName;
			if (qualifiedName.equals(registeredName))
			{
				if (javaLangImports != null && javaLangImports.contains(shortName))
				{
					imports.add(qualifiedName);
				}
				return shortName + indices;
			}
			else
			{
				return qualifiedName + indices;
			}
		}
		else
		{
			if (qualifiedName.startsWith(registeredName))
			{
				if (qualifiedName.length() == registeredName.length())
				{
					return baseName.replace('$', '.') + indices;
				}
				else
				{
					char character = qualifiedName.charAt(registeredName.length());
					if (character == '.' || character == '$')
					{
						return baseName.replace('$', '.') + indices;
					}
				}
			}
			return qualifiedName.replace('$', '.') + indices;
		}
	}

	public void addImport(String packageName, String shortName)
	{
		int firstBracket = shortName.indexOf("[");
		if (firstBracket != -1)
			shortName = shortName.substring(0, firstBracket);
		basicAdd(packageName, shortName, packageName + "." + shortName);
	}

	public void addImport(String qualifiedName)
	{
		int firstBracket = qualifiedName.indexOf("[");
		if (firstBracket != -1)
			qualifiedName = qualifiedName.substring(0, firstBracket);

		int lastDot = qualifiedName.lastIndexOf(".");
		String shortName = qualifiedName.substring(lastDot + 1);
		int firstDollar = shortName.indexOf("$");
		if (firstDollar != -1)
		{
			shortName = shortName.substring(0, firstDollar);
		}

		String packageName = lastDot == -1 ? null : qualifiedName.substring(0, lastDot);
		basicAdd(packageName, shortName, qualifiedName);
	}

	public void addMasterImport(String packageName, String shortName)
	{
		shortNameToImportMap.put(shortName, packageName + "." + shortName);
	}

	public void addJavaLangImports(List javaLangClassNames)
	{
		if (!javaLangClassNames.isEmpty())
		{
			javaLangImports = new HashSet();
			javaLangImports.addAll(javaLangClassNames);
		}
	}

	public boolean hasImport(String shortName)
	{
		return shortNameToImportMap.containsKey(shortName);
	}

	public void addCompilationUnitImports(String compilationUnitContents)
	{
		DOMFactory jdomFactory = new DOMFactory();
		IDOMCompilationUnit jdomCompilationUnit = jdomFactory.createCompilationUnit(compilationUnitContents, "Local");
		for (IDOMNode child = jdomCompilationUnit.getFirstChild(); child != null; child = child.getNextNode())
		{
			switch (child.getNodeType())
			{
				case IDOMNode.IMPORT :
					{
						IDOMImport jdomImport = (IDOMImport)child;
						String qualifiedName = jdomImport.getName();
						int lastDot = qualifiedName.lastIndexOf(".");
						String shortName = qualifiedName.substring(lastDot + 1);
						if (shortName.equals("*"))
						{
							String packageName = qualifiedName.substring(0, lastDot);
							importedPackages.add(packageName);
						}
						else
						{
							shortNameToImportMap.put(shortName, qualifiedName);
						}
						break;
					}
			}
		}
	}

	private void basicAdd(String packageName, String shortName, String qualifiedName)
	{
		if (shortName.equals("*"))
		{
			importedPackages.add(packageName);
			imports.add(qualifiedName);
		}
		else if (!shortNameToImportMap.containsKey(shortName) && (!getJavaLangTypes().contains(shortName)))
		{
			shortNameToImportMap.put(shortName, qualifiedName);

			if (!importedPackages.contains(packageName))
			{
				imports.add(qualifiedName);
			}
		}
	}
}
