/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.wizard;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;

/**
 * Extends the TestSuiteNewWizard to create the Http Test Suite.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public class HttpTestSuiteNewWizard 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public HttpTestSuiteNewWizard()
	{
		super();
		setWindowTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor(TestHttpImages.IMG_WIZBAN_NEW_HTTP_TESTSUITE));

		IDialogSettings dialogSettings = TestHttpPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("HttpTestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("HttpTestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		getLocationPage().setDescription(TestHttpPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
		
		getAttributeWizardPage().setTitle(TestHttpPlugin.getString("WIZ_TST_HTTP_SUITE_TTL"));
		getAttributeWizardPage().setDescription(TestHttpPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
		
		super.addPages();
	}	

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		IStructuredSelection structuredSelection = adjustSeletion();
		
		LocationPage locationPage = new LocationPage("location", structuredSelection) {
			/**
			 * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#validatePage()
			 */
			protected boolean validatePage() {
				setMessage(null);		
				if (!super.validatePage()) {
					return false;
				}
				
				if(!allowOverwrite())
				{
					IPath path = getContainerFullPath();
					if(path != null)
					{
						String fileName = getFileName();
						if(fileName.length() == 0) {
							setErrorMessage(null);
							return false;
						} else {
							/*
							 * Test for any invalid characters within the file name or if it begins with
							 * a period.
							 */
							String invalidChar = UIUtil.validateJavaFileName(fileName);
							if (invalidChar != null) {						
								if (Character.isDigit(invalidChar.charAt(0))) {
									String [] errors = { HyadesUIPlugin.getString("PHYSICAL_FILE_NAME"), HyadesUIPlugin.getString("NUMERIC_VALUE") };
									setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_EXT", errors));
									return false;					
								} else {
									String [] errors = { HyadesUIPlugin.getString("PHYSICAL_FILE_NAME"), invalidChar};
									setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_SPECIAL_CHAR", errors));
									return false;
								}							
							}
						} 
					}
				}		
				return true;
			}			
		};
		// Set the super.locationPage value
		setLocationPage(locationPage);
		
		String fileExtension = getFileExtension();
		if(fileExtension != null)
		{
			locationPage.setFileExtension(fileExtension);
			locationPage.setFileName("");
		}

		AttributeWizardPage attributeWizardPage = new AttributeWizardPage("nameDescription") {
			/**
			 * Returns whether this page's controls currently all contain valid 
			 * values.
			 * @return <code>true</code> if all controls are valid, and
			 * <code>false</code> if at least one is invalid
			 */
			protected boolean validatePage() {
				setErrorMessage(null);
				if (!super.validatePage()) {
					return false;
				}
					
				if((getItemName() != null) && (getItemName().trim().length() != 0)) {
					/*
					 * Test for any invalid characters within the file name
					 */
					String invalidChar = UIUtil.validateJavaFileName(getItemName());
					if (invalidChar != null) {		
						if (Character.isDigit(invalidChar.charAt(0))) {
							String [] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), HyadesUIPlugin.getString("NUMERIC_VALUE") };
							setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_EXT", errors));
							return false;					
						} else {
							String [] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), invalidChar};
							setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_SPECIAL_CHAR", errors));
							return false;
						}							
					}
				}
				return true;
			}			
		};
		// Set the super.attributeWizardPage value
		setAttributeWizardPage(attributeWizardPage);
		getAttributeWizardPage().addActivationListener(this);
	}
}
