/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.launch.delegates.BasicTestLaunchConfigurationDelegate;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpLaunchConfigurationDelegate extends BasicTestLaunchConfigurationDelegate {
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate#getLaunchedElement(org.eclipse.debug.core.ILaunchConfiguration)
	 */
    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
    	return HttpTestLaunchConfigurationFacade.getTest(configuration, getResourceSet());
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate#invokeTestExecutionHarness(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, java.lang.StringBuffer)
	 */
	public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode,
			StringBuffer errorMessages) throws CoreException {
		// Compute parameters
    	TPFTest test = getLaunchedTest(configuration);
    	TPFTestSuite testSuite = null;
    	TPFTest subTest = null;
    	if (test instanceof TPFTestCase) {
    		subTest = test;
    		testSuite = ((TPFTestCase)subTest).getTestSuite();
    	} else if (test instanceof TPFTestSuite) {
    		testSuite = (TPFTestSuite)test;
    		subTest = test;
    	}
    	
    	HttpRunHandler.adjustTestUserCount(testSuite, configuration);
    	
    	TPFDeployment deployment = getDeployment(configuration);	    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	String tehLocation = getTestExecutionHistoryLocation(configuration).getFullPath().toString();
    	String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);
    	
		TestExecutionHarness teh = new TestExecutionHarness();
		IExecutor executor = teh.launchTest(
			(ITestSuite)testSuite,
			(ITest)subTest,
			deployment,
			port,
			tehLocation,
			tehName,
			true,
			false,
			errorMessages);
		SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong(TestUI.SAVE_INTERVAL));
		return executor;
	}
}