/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;

/**
 * @author jnevicos
 * @author jcanches (bugzilla_64189)
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpTestLaunchConfigurationFacade
		extends TestLaunchConfigurationFacade {
	
	public final static String LAUNCH_CONFIGURATION_TYPE =  "org.eclipse.hyades.test.http.launch.urlTest"; //$NON-NLS-1$
	
	public static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE);
	}
	
	private final static String PROPERTY_URLTEST = PROPERTY_PREFIX + ".urlTest"; //$NON-NLS-1$
	public final static String PROPERTY_USERS = PROPERTY_URLTEST + ".users";

	public static int getNumberOfUsers(ILaunchConfiguration configuration) throws CoreException {
		return configuration.getAttribute(PROPERTY_USERS, 1);
	}
	
	public static void setNumberOfUsers(ILaunchConfigurationWorkingCopy configuration, int nb) {
		configuration.setAttribute(PROPERTY_USERS, nb);
	}
}
