/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.hyades.resources.database.internal.impl.QueryFactoryImpl;
/**
 * This factory allows you to create an object query or a reference query.
 * <p>
 * There is one QueryFactory instance that you can access using the INSTANCE
 * field.
 */
public interface QueryFactory {
	/**
	 * Creates an object query.
	 */
	ObjectQuery createObjectQuery();

	/**
	 * Creates a reference query.
	 */
	ReferenceQuery createReferenceQuery();

	/**
	 * Use this field to access the instance of the QueryFactory.
	 */
	QueryFactory INSTANCE = new QueryFactoryImpl();

} // QueryFactory
