/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class determines if the given referencedId is in the given reference for
 * the given object.
 */
public class Contains extends DBCommand {
	protected Integer id;
	protected EReference reference;
	protected Integer referencedId;

	public Contains(JDBCHelper helper, DBMap map, Integer id, EReference reference, Integer referencedId) {
		super(helper, map);
		this.id = id;
		this.reference = reference;
		this.referencedId = referencedId;
	}

	/**
	 * Returns a Boolean indicating whether the referencedId is in the
	 * reference.
	 */
	public Object execute() throws Exception {
		StatementFactory factory = StatementFactory.INSTANCE;
		QueryStatement query = factory.createContainsQuery(helper.getDatabaseType(), dbMap, id, reference, referencedId);
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query.getStatement());
		boolean contains = rs.next();
		rs.close();
		statement.close();

		if (contains)
			return Boolean.TRUE;
		else
			return Boolean.FALSE;
	}
} // GetReferenceCountCommand
