/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This class aims to populate a Thread Interaction UML2 Sequence Diagram.
 */
public class ThreadInteractions extends BaseLifelineLoader {
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	public EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getThread(); // TRCThread
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	public int getLifeLineCategory(EObject to) {
		return TraceInteractions.CATEGORY_THREAD;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	public String getLifeLineTitle(EObject to, boolean long_) {
		TRCThread thread = (TRCThread)to;
		return thread.getName() +
			   (long_ ? " "+TraceSDPlugin.getResourceString("STR_PROCESS")+" "+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			   	thread.getProcess().getAgent().getAgentProxy().getProcessProxy().getName()+" [Pid "+thread.getProcess().getPid()+"]" : ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * The runtimeId of agentProxy and the lifeline title
	 */
	public String getLifeLineId(EObject eo) {
		TRCAgentProxy ap;
		ap = ((TRCThread)eo).getProcess().getAgent().getAgentProxy();
		return ap.getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_THREAD_INTERACTION"); //$NON-NLS-1$
	}
}
