/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;

/**
 * A draft with some build-time datas
 */
public class TraceLifelineDraft {
	
	private Lifeline lifeline;
	private int start, end, nbUser;
	private boolean filtered;
	private TRCFullMethodInvocation methodInvocation;
	
	public void setStart(int start_) {
		start = start_;
	}

	public int getStart() {
		return start;
	}
	
	public void setEnd(int end_) {
		end = end_;
	}
	
	public int getEnd() {
		return end;
	}
	
	public void addAUser() {
		nbUser++;
	}

	public void removeAUser() {
		nbUser--;
	}

	public int getNbUser() {
		return nbUser;
	}

	public void setLifeline(Lifeline lifeline_) {
		lifeline = lifeline_;
	}
	
	public Lifeline getLifeline() {
		return lifeline;
	}

	public void setFiltered(boolean filtered) {
		this.filtered = filtered;
	}

	public boolean isFiltered() {
		return filtered;
	}

	public void setMethodInvocation(TRCFullMethodInvocation methodInvocation_) {
		methodInvocation = methodInvocation_;
	}

	public TRCFullMethodInvocation getMethodInvocation() {
		return methodInvocation;
	}
}
