/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.execution.core.task;

import org.eclipse.core.runtime.NullProgressMonitor;

/**
 * A test class that exercises progress tasks and the related underlying
 * classes.
 * 
 * @author Scott E. Schneider
 */
public class Test {

    private static int count = 0;

    public static void main(String[] args) {

        ProgressiveTask task = new ProgressiveTask("Test", new Runnable() {
            public void run() {
                for (int i = 0; i < 1000000000; i++) {
                    if (i % 100000000 == 0) {
                        System.out.println(java.lang.Thread.currentThread()
                                + " -- " + i);
                    }
                }
            }
        }, new NullProgressMonitor() {
            public boolean isCanceled() {
                Test.count++;
                return count > 5;
            }
        });

        task.execute(ProgressiveTask.Synchronicity.SYNCHRONOUS);

        System.out.println("********* Test complete!");

    }
}