/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;

public class OpenExecutionStatisticViewAction extends OpenTraceViewAction {

	public OpenExecutionStatisticViewAction() {
		super("");
	}

	public OpenExecutionStatisticViewAction(String label) {
		super(label);
	}

	public OpenExecutionStatisticViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public boolean isVisibleForType(Object mofObject) {
		return true;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			ExecutionStatisticViewer2 view =
				(ExecutionStatisticViewer2) persp.showView(
					"org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2");
			
			if(view != null){
				 view.addViewPage(getMofObject());
			}

		} catch (Exception e) {
			String msg =
				TraceUIPlugin.getString("STR_OPEN_EXECUTION_STATISTIC_VIEW_ERROR_");
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}

	}

	public void run(IAction action) {
		run();
	}
}
