/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.views.internal.*;


public class CoverageStatisticViewer extends MultiLevelStatisticMethodViewer {

	protected static final String _title =
		TraceUIPlugin.getString("STR_COVERAGE_ST_TITLE");

	public CoverageStatisticViewer() {
		super();
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		return new CoverageStatisticPage(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
}
