/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.emf.ecore.EObject;
import java.util.Vector;

import org.eclipse.jface.action.*;

import org.eclipse.hyades.trace.views.internal.*;

public class ExecutionStatisticViewer2 extends MultiLevelStatisticMethodViewer {

	protected Action _percentMode;
	protected Action _deltaColumns;	
	
	protected Action _instanceLevel;	
	
	protected static final String _title =
		TraceUIPlugin.getString("STR_EXECUTION_ST_TITLE");

	public ExecutionStatisticViewer2() {
		super();
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		return new ExecutionStatisticPage2(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
	
	
	protected void getLevelActions(Vector actions)
	{
		super.getLevelActions(actions);
		
		String strInstanceLevel = TraceUIPlugin.getString("STR_ST_INSTANCE_LEVEL");

		_instanceLevel = new Action(strInstanceLevel) {
			public void run() {
				MultiLevelStatisticPage page = (MultiLevelStatisticPage) getCurrentPage();

				if (page == null)
					return;

				setCheckedLevels(page, ExecutionStatisticView.INSTANCE_LEVEL);

			}
			public int getStyle() {
				return IAction.AS_CHECK_BOX;
			}
		};
		_instanceLevel.setText(strInstanceLevel);
		TracePluginImages.setImageDescriptors(
				_instanceLevel,
			TracePluginImages.T_LCL,
			TracePluginImages.IMG_OBJ);
		_instanceLevel.setDescription(strInstanceLevel);
		_instanceLevel.setToolTipText(strInstanceLevel);
		_instanceLevel.setEnabled(true);

		actions.addElement(new Separator());
		actions.addElement(_instanceLevel);		
	}
	
	
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:54:24 PM)
	 */
	public void getActions(Vector actions)
	{
	 	String strShowPercent = TraceUIPlugin.getString("SHOW_PERCENT");  	  										
		_percentMode = new Action(strShowPercent)
		{
			public void run()
			{
				ExecutionStatisticPage2 page = (ExecutionStatisticPage2)getCurrentPage();

				if(page == null)
				  return;
				page.getView().getShowPercentAction().run();      
			}
			public int getStyle() { return IAction.AS_CHECK_BOX; }


		};

		_percentMode.setText(strShowPercent);
		TracePluginImages.setImageDescriptors(_percentMode,TracePluginImages.T_LCL,TracePluginImages.IMG_PERCENT);			
		_percentMode.setDescription(strShowPercent);   
		_percentMode.setToolTipText(strShowPercent);
		_percentMode.setEnabled(true);

		String strShowDelta = TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS");	
		_deltaColumns = new Action(strShowDelta)
		{
			public void run()
			{
				ExecutionStatisticPage2 page = (ExecutionStatisticPage2)getCurrentPage();

				if(page == null)
				  return;
				page.getView().getDeltaColumnsAction().run();      
			}
			
			public int getStyle() { return IAction.AS_CHECK_BOX; }
			
		
		};

		_deltaColumns.setText(strShowDelta);
		TracePluginImages.setImageDescriptors(_deltaColumns,TracePluginImages.T_LCL,TracePluginImages.IMG_DELTACOLUMNS);
		_deltaColumns.setDescription(strShowDelta);   
		_deltaColumns.setToolTipText(strShowDelta);
		_deltaColumns.setEnabled(true);
		
		int actionSize = actions.size();
		
		super.getActions(actions);
		
		if ((actionSize+1)< actions.size())
		{
			actions.insertElementAt(_percentMode, actionSize+2);
			actions.insertElementAt(_deltaColumns, actionSize+3);
		}
		else
		{
			actions.addElement(_percentMode);
			actions.addElement(_deltaColumns);
		}
	}
	
	public Action percentMode() {
		return _percentMode;
	}

	public Action deltaColumns() {
		return _deltaColumns;
	}	
	
	public Action getInstanceLevel() {
		return _instanceLevel;
	}		
	
	protected void setActionsNull()
	{
		super.setActionsNull();
		_instanceLevel = null;
	}	

}
