/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class MultiLevelStatisticPage extends TraceViewerPage {
	
	protected MultiLevelStatisticView _view;	
	
	public MultiLevelStatisticPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}	
	
	protected abstract MultiLevelStatisticView displayData(Composite parent);
	
	/**
	 * This method :
	 * - activates the method coverage analysis
	 * - displays the results and add a contextual menu 
	 */
	public void createControl(Composite parent) {

		//Display data
		_view = displayData(parent);

		//Contextual menu
		setContextMenu(_view.getTable(), _view.getTableViewer());
		makeActions();

		//TODO: What's the help reference for coverage?
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			this.getControl(),
			TraceUIPlugin.getPluginId()+".clst0000");
	}
		
	/**
	 * disposes the CoverageStatistic view
	 */
	public void dispose() {
		if (_view != null && _view.getControl() != null)
			super.dispose();

		//dispose method of the CoverageStatistic class
		if (_view != null) {
			_view.dispose();
		}

		_view = null;
	}

	/**
	 * Contribute to the view popup menu
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
		if (_view != null) {
			_view.menuAboutToShow(menu);
		}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:54:24 PM)
	 */
	public void makeActions()
	{
		getTraceViewer().makeActions();
	}	
	
	/**
	 * refresh the content of the page when the "RefreshViews"
	 * command is activated
	 */
	public void refreshPage() {
		getView().updateButtons();
		getView().refresh();
	}	
	
	/**
	 * @return the Package level action
	 */
	public Action getPackageLevel() {
		return ((MultiLevelStatisticViewer) _viewer).getPackageLevel();
	}

	/**
	 * @return the Class level action
	 */
	public Action getClassLevel() {
		return ((MultiLevelStatisticViewer) _viewer).getClassLevel();
	}	
	
	/**
	 * the control is used by the viewer to display this page
	 */
	public Control getControl() {
		return getView().getControl();
	}
	
	/**
	 * set the focus on the view
	 */
	public void setFocus() {
		getControl().setFocus();
		getView().showNewSelection();
	}	

	/**
	 * the same element must be selected in all the statistics views
	 */
	public void selectionChanged() {
		getView().selectionChanged();
	}	
	
	/**
	 * @return the CoverageStatistic instance
	 */
	public MultiLevelStatisticView getView() {
		return _view;
	}	
	
	/**
	 * update the content of the page
	 */
	public void update(boolean newPage) {
		if (newPage) {
			getView().updateUI(getView().getColumnDataList());
		}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (8/1/2001 6:31:38 PM)
	 * @return org.eclipse.jface.action.Action
	 */
	public Action openSource() {
		return ((MultiLevelStatisticViewer)_viewer).openSource();
	}	
	
	public boolean isEmpty()
	{
		return _view.isEmpty();
	}	
	
	public void updateButtons(int level)
	{
		getPackageLevel().setChecked(MultiLevelStatisticView.PACKAGE_LEVEL == level);
		getClassLevel().setChecked(MultiLevelStatisticView.CLASS_LEVEL == level);		
	}
}
