/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.util.internal;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.internal.util.OpenJavaSource;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class OpenSource
{
/**
 * openSource is takes an object of either a JMessage, JObject or JClass and attempts
 * to locate the source for the definition of that object within the workbench.  If the
 * source is found, the text editor within the Java Perspective is opened and the source 
 * is highlighted.
 * @param Object selection - the object for which you want the source definition.
 */	
public static void openSource(Object selection) {	
	
	if (selection != null && selection instanceof EObject) {
		EObject eObj = (EObject)selection;
		final String pattern = getPattern(eObj);
		final int javaType = getType(eObj);
		
		if (pattern != null && javaType != IJavaSearchConstants.UNKNOWN) {
			BusyIndicator.showWhile(Display.getDefault(), new Runnable() {
				public void run() {
					// Now call the core utility function to actually locate and open the source for the object.
					if(!OpenJavaSource.openSource(pattern, javaType, null, true))
					{
						MessageDialog.openInformation(
							UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
							UIPlugin.getResourceString("STR_TRACE_MSG"),
							HyadesUtil.change(UIPlugin.getResourceString("STR_SOURCE_NOT_FOUND_INFO_"), "%1", pattern));
					}
				}
			});
			return;
		}
	}
	
	MessageDialog.openInformation(
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
			UIPlugin.getResourceString("STR_TRACE_MSG"),
			UIPlugin.getResourceString("STR_EMPTY_SOURCE_NOT_FOUND_INFO_"));		
}

/*
 * Temporary API: To be used by Toulouse team ONLY.
 * Do not change this method without consultation.
 */
public static IFile getSourceFile(EObject obj) {
	if (obj != null) {
		String pattern = getPattern(obj);
		int javaType = getType(obj);
		
		if (pattern != null && javaType != IJavaSearchConstants.UNKNOWN) {
			return OpenJavaSource.getSourceFile(pattern, javaType, null);
		}
	}
	return null;
}

private static String getPattern(Object selection) {
	// Added: Handle the case where the user selects a package, then clicks on the
	// Open Source button on the toolbar - see bugzilla 51854
	if(selection == null || selection instanceof TRCPackage) {
		return null;
	}
			
	if(selection instanceof TRCMethodInvocation)
	{
		selection = ((TRCMethodInvocation)selection).getMethod();
	}
	
   	if (selection instanceof TRCMethod) {
		TRCMethod trcMethod = (TRCMethod) selection;
		
		if((trcMethod.getModifier() & TRCMethodProperties.JAVA_CONSTRUCTOR) !=0 )
		{
			// For constructors we only require the parameter signature appended to the class name
			TRCClass clas = trcMethod.getDefiningClass();
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				return (new StringBuffer())
				                     .append(clas.getName()).append(trcMethod.getSignature()).toString();			
			else			
				return (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).append(trcMethod.getSignature()).toString();
		}
		
		else
		 {
			TRCClass clas = trcMethod.getDefiningClass();
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				return (new StringBuffer())
				                     .append(clas.getName()).append(".")
				                     .append(trcMethod.getName()).append(trcMethod.getSignature()).toString();			
			else			
				return (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).append(".")
				                     .append(trcMethod.getName()).append(trcMethod.getSignature()).toString();
			
		}
	} 
	else {
		if (selection instanceof TRCObjectReference)
		{
			TRCObjectReference obj = (TRCObjectReference)selection;
			if (TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION)==TraceConstants.OBJ_REF_REFERANDS)
			{
				selection = obj.getOwner();
			}
			else
			{
				selection = obj.getTarget();
			}
		}
		if (selection instanceof TRCObject) {
			
			TRCObject obj = (TRCObject)selection;
			if(obj.getIsA()==obj.getProcess().getClassClass())
				selection = findClassType(obj);
			else
				selection = obj.getIsA();
		} 
		
		if (selection instanceof TRCClass) {
			
			TRCClass clas = (TRCClass) selection;
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				return clas.getName();
			else			
				return (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).toString();
		} 
	}
	return null;
}

private static int getType(Object selection) {
	int javaType;
	
	// Added: Handle the case where the user selects a package, then clicks on the
	// Open Source button on the toolbar - see bugzilla 51854
	if(selection == null || selection instanceof TRCPackage) {
		return IJavaSearchConstants.UNKNOWN;
	}
			
	if(selection instanceof TRCMethodInvocation) {
		selection = ((TRCMethodInvocation)selection).getMethod();
	}
	
   	if (selection instanceof TRCMethod) {
		TRCMethod trcMethod = (TRCMethod) selection;
		
		if((trcMethod.getModifier() & TRCMethodProperties.JAVA_CONSTRUCTOR) !=0 ) {
			javaType = IJavaSearchConstants.CONSTRUCTOR;
		}
		else {
			javaType = IJavaSearchConstants.METHOD;
		}
	} 
	else {
		javaType = IJavaSearchConstants.TYPE;
	}
	return javaType;
}

private static Object findClassType(TRCObject obj) {
	for (Iterator iter1 = obj.getProcess().getPackages().iterator(); iter1.hasNext();) {
		TRCPackage aPackage = (TRCPackage) iter1.next();
		for (Iterator iter2 = aPackage.getClasses().iterator(); iter2.hasNext();) {
			TRCClass aClass = (TRCClass) iter2.next();
			for (Iterator iter3 = aClass.getClassObjects().iterator();iter3.hasNext();) {
				TRCObject aObject = (TRCObject) iter3.next();
				if(aObject == obj)
					return aClass;
			}
		}
	}
	return obj.getIsA();
}
	

}