/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;


public class Thd implements Externalizable
{
   private static int _curVersion = 1; // update when version changes (data added)
   private int _version = -1;

   public Thd( String name, String threadId, String state, String priority )
   {
      _version = _curVersion;
      _name = name;
      _ID = DumpData.getID();
      _stack = null;
      _stackNative = null;
      _threadId = threadId;
      _priority = priority;
      _state = state;
      _stack = new Vector();
      _stackNative = new Vector();
      _waitMonitor = null;
      _props = new Properties();
      _nextByTOS = null;
      _prevByTOS = null;
      _fHtml = false;
   }


   public String getThreadId()
   {
      return _threadId;
   }
   public void setProperty( String prop, String val )
   {
      _props.setProperty( prop, val );
   }

   public String getProperty( String prop )
   {
      return _props.getProperty( prop );
   }

   public void addStackEntry( StkEntry stkEntry )
   {
      _stack.add( stkEntry );
   }

   public void addStackEntryNative( StkEntryNative stkEntryNative )
   {
      _stackNative.add( stkEntryNative );
   }

   public String getName() 
   {
      return _name;
   }


   public void setWaitMonitor( Monitor waitMonitor )
   {
      _waitMonitorID = waitMonitor._ID;
      _waitMonitor = waitMonitor;
   }

   public int getWaitMonitorId()
   {
      return _waitMonitorID;
   }

   public boolean waitingForWebWork()
   {
      return boolPropVal( "WAITING_FOR_WEB_WORK" );
   }

   public boolean waitingForOtherWork()
   {
      return boolPropVal( "WAITING_FOR_OTHER_WORK" );
   }


   public String getServletName()
   {
      return getProperty( "SERVLET_NAME" ); // ok if null, caller handles it
   }

   public String[] getEjbNames()
   {
      return new String[0];
   }

   public boolean isServletThread()
   {

      boolean fRet = false;

      /*
      if( getProperty( "THREAD_TYPE" ).equalsIgnoreCase( "servlet handler" ))
         fRet = true;
      */

      fRet = isExecutingWebWork() || waitingForWebWork() || isEmptyServletThd();

      return fRet;
   }

   public boolean isEmptyServletThd()
   {
		return getName().indexOf("Servlet") != -1 && getStkSize() == 0;
   }

   public boolean isOrbThread()
   {

      boolean fRet = false;

      /*
      if( getProperty( "THREAD_TYPE" ).equalsIgnoreCase( "servlet handler" ))
         fRet = true;
      */

      fRet = isExecutingRemoteOrbWork() || waitingForOrbWork() || isEmptyOrbThd();

      return fRet;
   }

   public boolean isEmptyOrbThd()
   {
		return getName().indexOf("ORB") != -1 && getStkSize() == 0;
   }

   public boolean isExecutingWebWork()
   {
      return boolPropVal( "EXECUTING_WEB_WORK" );
   }


   public boolean isExecutingOrbWork()
   {
      return boolPropVal( "EXECUTING_ORB_WORK" );
   }

   public boolean isExecutingRemoteOrbWork()
   {
      return boolPropVal( "EXECUTING_REMOTE_ORB_WORK" );
   }

   public boolean waitingForOrbWork()
   {
      return boolPropVal( "WAITING_FOR_REMOTE_ORB_WORK" );
   }

   public boolean waitingForInfrastructureWork()
   {
      return boolPropVal( "WAITING_FOR_INFRASTRUCTURE_WORK" );
   }

   public boolean waitingForQueueWork()
   {
      return boolPropVal( "WAITING_FOR_QUEUE_WORK" );
   }
   /* 
    * This function is used within the deadlock detection code to filter threads that are known
    * self-waiters
    */
   public boolean waitingForWork() {
   		return waitingForOrbWork() || waitingForWebWork() || 
                waitingForQueueWork() || waitingForOtherWork();
   }
   public boolean firstStackDifference( Vector callers, Thd t)
   {
      // given another thread, return the first entry of
      // its stack that's different than this thread's

      StkEntry seMine = null;
      StkEntry seOther = null;

      int myStkSize = _stack.size();

      int otherStkSize = t._stack.size();

      int maxSize = ( myStkSize > otherStkSize ) ? otherStkSize : myStkSize;

	  //System.err.println("[Thd] \tName of mine:\t" + getName());
	  //System.err.println("[Thd] \tName of other:\t" + t.getName());

      for( int i = 0; i < maxSize; ++i )
      {
         StkEntry mine = (StkEntry)_stack.elementAt( i );
         StkEntry other = (StkEntry)t._stack.elementAt( i );

		 //System.err.println("[Thd] \tmine:\t" + mine.getFQName());
		 //System.err.println("[Thd] \tother:\t" + other.getFQName());

         if( ! mine.getFQName().equals( other.getFQName() ) || i == maxSize-1 )
         {
			//System.err.println("[Thd] \tDifference found");
            boolean found = false;
            for( int j = 0; j < callers.size(); ++j )
            {
               Caller caller = (Caller)callers.elementAt( j );
               StkEntry se = caller._stkEntry;

			   //System.err.println("[Thd] \t\tExamining caller list: \t" + se.getFQName());

               if( se.getFQName().equals( other.getFQName() ) )
               {
                  found = true; 
                  ++caller._count;
				  //System.err.println("[Thd] \t\tCaller matched.  Count: \t" + caller._count);
                  break;
               }
            }
            if( !found )
            {
			   //System.err.println("[Thd] \t\tNo match.  Creating new caller for: " + other.getFQName());
               Caller caller = new Caller();
               caller._stkEntry = other;
               caller._count = 1;
               callers.add( caller );
            }
            return true;
         }
      }

	  // No differences found... check if priorThd has a deeper stack
      if( otherStkSize > myStkSize )
         System.out.println( TAUtils.getNLSValue("ta.warnmsg.AnalysisIncomplete", "WARNING: stack diff analysis incomplete for thread") + " " + t.getName() );

      return false;
   }

   // the caller functions are used locally by the DumpData.print function
   // they don't need to be very sophisticated, so they're made simple.
   // Ok, I made a mistake.  I'll fix it later.
   public static int getCallerCount( Object caller )
   {  // evil downcasting :)
      return((Caller)caller)._count;
   }
   public static String getCallerName( Object caller )     
   {
      return((Caller)caller)._stkEntry.getFQName();
   }


   public Vector format( int indent, boolean fHtml )
   {
      Vector lines = new Vector();

      _fHtml = fHtml;
      String sIndent = "";
      for( int i = 0; i < indent; ++i )
         sIndent += sTab;
      lines.add( " " );
      lines.add( sIndent + html("<a name=" + getThreadId() + "></a>") + TAUtils.getNLSValue("ta.format.ThreadInformation", "Thread information") + ":" );
      lines.add( sIndent + sTab + TAUtils.getNLSValue("ta.format.ThreadType", "Thread type") + "..................... " + _props.getProperty( "THREAD_TYPE" ) );
      lines.add( sIndent + sTab + TAUtils.getNLSValue("ta.format.Name", "name") + "............................ " + _name );
      //lines.add( sIndent + sTab +"UID............................. " + _ID );
      lines.add( sIndent + sTab + TAUtils.getNLSValue("ta.format.ThreadID", "thread id") + "....................... " + _threadId );
      lines.add( sIndent + sTab + TAUtils.getNLSValue("ta.format.Priority", "priority") + "........................ " + _priority );
      lines.add( sIndent + sTab + TAUtils.getNLSValue("ta.format.State", "state") + "........................... " + _state );
      String sPrevByTOS = "";
      String sNextByTOS = "";
      if( _nextByTOS != null )
      {
         sNextByTOS = "<a href=#" + _nextByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.next", "next") + "]</a> ";
      }

      if( _prevByTOS != null )
      {
         sPrevByTOS = "<a href=#" + _prevByTOS.getThreadId() + ">[" + TAUtils.getNLSValue("ta.string.previous", "previous") + "]</a> ";
      }

      if( fHtml )
      {

         if( _nextByTOS != null || _prevByTOS != null )
            lines.add( sIndent + sTab + " " + sPrevByTOS + sNextByTOS + TAUtils.getNLSValue("ta.msg.WithSameTOS", "with same top of stack") +".");
      }

      if( !waitingForWebWork() && ! waitingForOrbWork() && _waitMonitor != null )
      {
         lines.add( sIndent + "\t" + TAUtils.getNLSValue("ta.msg.WaitingOnMonitor", "Waiting on monitor") + "................ " + _waitMonitor.getName() );
      }
      lines.add( sIndent + sTab +TAUtils.getNLSValue("ta.msg.WaitingForWebWork", "Waiting for web work") + "............. " + yesOrNo( waitingForWebWork( )) );
      lines.add( sIndent + sTab +TAUtils.getNLSValue("ta.msg.ExecutingWebOrLocalEjbWork", "Executing web or local EJB work") + ".. " + yesOrNo( isExecutingWebWork() || isExecutingOrbWork() || isExecutingRemoteOrbWork() ) );
      lines.add( sIndent + sTab +TAUtils.getNLSValue("ta.msg.WaitingForRemoteOrb", "Waiting for remote orb work") + "...... " + yesOrNo( waitingForOrbWork( )) );

      if( _stack.size() <= 0 && _stackNative.size() <= 0 )
         lines.add( sIndent + sTab +sTab +"* " + TAUtils.getNLSValue("ta.msg.NoStackInfo", "no stack information available") + " *" );
      else
      {
          if( _stack.size() > 0 )
          {
              lines.add( sIndent + sTab +TAUtils.getNLSValue("ta.string.Stack", "Stack") + ": " );

              for( int i = 0; i < _stack.size(); ++i )
              {
                 StkEntry se = (StkEntry)_stack.get( i );
                 lines.add( se.format( indent ));
              }
          }

          if( _stackNative.size() > 0 )
          {
              lines.add( sIndent + sTab + "Native Stack" + ": " );

              for( int i = 0; i < _stackNative.size(); i++ )
              {
                  StkEntryNative sen = (StkEntryNative) _stackNative.get(i);
                  lines.add( sen.format( indent ));
              }
          }
      }
      return lines;
   }

   public static String yesOrNo( boolean b )
   {
      if( b )
		  return TAUtils.getNLSValue("ta.string.yes", "yes");

      return( TAUtils.getNLSValue("ta.string.no", "no") );
   }

   public void print( int indent, boolean fHtml )
   {
      Vector lines = format( indent,fHtml );
      for( int i = 0; i < lines.size(); ++i )
      {
         System.out.println( lines.elementAt( i ));
      }

   }


   public boolean stackContainsLike( String stackEntryPattern )
   {
      int idx = 0;
      boolean fRet = false;

      StkEntry se = getStkEntry( idx );
      while( se != null )
      {
         if( se.getFQName().indexOf( stackEntryPattern ) != -1 )
         {
            fRet = true;
            break;
         }
         se = getStkEntry( ++idx );
      }
      return fRet;
   }

   public StkEntry getTOS()
   {
      if( _stack.size() > 0 )
         return(StkEntry)_stack.elementAt( 0 );
      else return null;
   }

   public StkEntry getBOS()
   {
      // bottom of stack i.e. the root.
      if( _stack.size() > 0 )
         return(StkEntry)_stack.elementAt( _stack.size() - 1 );
      else return null;
   }

   public int getStkSize()
   {
      return _stack.size();
   }

   public int getStkNativeSize()
   {
      return _stackNative.size();
   }

   public StkEntry getStkEntry( int ndx )
   {
	  // measured from the top of stack
      StkEntry retVal = null;
      if( ndx < _stack.size() )
      {
         retVal = (StkEntry)_stack.elementAt( ndx );
      }
      return retVal;
   }
   
   public StkEntryNative getStkEntryNative( int ndx )
   {
	  // measured from the top of stack
      StkEntryNative retVal = null;
      if( ndx < _stackNative.size() )
      {
         retVal = (StkEntryNative)_stackNative.elementAt( ndx );
      }
      return retVal;
   }

   protected boolean boolPropVal( String propName )
   {
      boolean fRet = false;
      String sRet = getProperty( propName );
      if( sRet != null && sRet.equals( "true" ) )
         fRet = true;
      return fRet;
   }

   private String html( String sHtml )
   {
      if( _fHtml ) return sHtml;
      else return "";
   }
/*
   private void writeObject(java.io.ObjectOutputStream out) throws IOException
   {
      out.writeInt(     _version );
      out.writeObject(  _name );
      out.writeInt(     _ID );
      out.writeObject(  _stack );
      out.writeObject(  _threadId );
      out.writeObject(  _priority );
      out.writeObject(  _state );
      out.writeObject(  _waitMonitor );
      out.writeObject(  _props );
      out.writeObject(  _nextByTOS );
      out.writeObject(  _prevByTOS );
      out.writeBoolean( _fHtml );
   }

   private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException 
   {
      _version    = in.readInt();
      _name       = (String)in.readObject();
      _ID         = in.readInt();
      _stack      = (Vector)in.readObject();
      _threadId   = (String)in.readObject();
      _priority   = (String)in.readObject();
      _state      = (String)in.readObject();
      _waitMonitor = (Monitor)in.readObject();
      _props      = (Properties)in.readObject();
      _nextByTOS  = (Thd)in.readObject();
      _prevByTOS  = (Thd)in.readObject();
      _fHtml      = in.readBoolean();

   }
*/

   public void writeExternal( ObjectOutput out) throws IOException
   {
      out.writeInt(     _version );
      out.writeObject(  _name );
      out.writeInt(     _ID );
      out.writeObject(  _stack );
      out.writeObject(  _stackNative );
      out.writeObject(  _threadId );
      out.writeObject(  _priority );
      out.writeObject(  _state );
      out.writeInt(     _waitMonitorID );
      out.writeObject(  _props );
      out.writeBoolean( _fHtml );
      //System.out.println( "Thd.writeExternal" );
   }

   public void readExternal( ObjectInput in) throws IOException, ClassNotFoundException 
   {
      _version    = in.readInt();
      _name       = (String)in.readObject();
      _ID         = in.readInt();
      _stack      = (Vector)in.readObject();

      Object unknown = in.readObject();
      try
      {
          // check for new format...
          _stackNative = (Vector) unknown;
          _threadId    = (String) in.readObject();
      }
      catch( ClassCastException cce )
      {
          // must be old dump format...
          _stackNative = new Vector();
          _threadId = (String) unknown;
      }
      _priority   = (String)in.readObject();
      _state      = (String)in.readObject();

      _waitMonitorID = in.readInt();
      _props      = (Properties)in.readObject();
      _fHtml      = in.readBoolean();
      //System.out.println( "Thd.readExternal" );

   }

   int getId()
   {
      return _ID;
   }

   public Thd() // for externalization
   {
   }


   //private String dummyStreamTestVar = null;
   public String _name     = null;
   public int _ID;
   public Vector _stack;
   public Vector _stackNative;
   public String _threadId = null;
   public String _priority = null;
   public String _state    = null;
   public int _waitMonitorID = 0;
   public Monitor _waitMonitor = null;
   public Properties _props = null;
   private boolean _fHtml = false;
   private boolean _selfWaiter = false;

   // end of version 1 vars
   // place version 2 vars here


   // 
   // place all statics and transients below 
   //
   private static String sTab = "   ";
   public transient Thd _nextByTOS = null;
   public transient Thd _prevByTOS = null;

   class Caller
   {
	   public StkEntry _stkEntry = null;
	   public int _count = 1;
   }
  /**
   * @return
   */
  public boolean isSelfWaiter()
  {
    return _selfWaiter;
  }

  /**
   * @param b
   */
  public void setSelfWaiter(boolean b)
  {
    _selfWaiter = b;
  }

}


