/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PDPluginImages
{
  private static URL fgIconBaseURL= null;

	static {
		String pathSuffix= "icons/full/"; //$NON-NLS-1$
		try {
			fgIconBaseURL= new URL(UIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
		} catch (MalformedURLException e) {
		}
	}  
	
	/*
	 * Set of predefined Image Descriptors.
	 * there following String are all $NON-NLS-1$
	 */
	public static final String T_LCL		= "lcl16"; //$NON-NLS-1$
	public static final String T_TOOL	= "tool16"; //$NON-NLS-1$
	public static final String T_VIEW	= "view16"; //$NON-NLS-1$
	public static final String T_OBJ		= "obj16"; //$NON-NLS-1$
	public static final String T_WIZBAN	= "wizban"; //$NON-NLS-1$
	
	
  // there following String are all $NON-NLS-1$
  public static final String IMG_UI_QUESTION    		= "unknown_obj.gif";//"question.gif";//$NON-NLS-1$
  public static final String IMG_FILTER_ENABLED    	= "enable_obj.gif";//"enabled.gif";  //$NON-NLS-1$
  public static final String IMG_FILTER_DISABLED 	= "disable_obj.gif";//"disabled.gif";//$NON-NLS-1$
  public static final String IMG_FILTER          	= "filter_obj.gif";//"filter.gif";  //$NON-NLS-1$
  public static final String IMG_UI_MONITOR    		= "monitor_obj.gif"; //"monitor.gif";//$NON-NLS-1$
  public static final String IMG_UI_NODE       		= "node_obj.gif"; //"node.gif";   //$NON-NLS-1$
  public static final String IMG_UI_CLASS      		= "class_obj.gif"; //$NON-NLS-1$
  public static final String IMG_UI_PROCESS    		= "process_obj.gif";//"process.gif";    //$NON-NLS-1$
  public static final String IMG_UI_AGENT  		   = "agent_obj.gif"; //$NON-NLS-1$
  public static final String IMG_UI_MON_AGENT  		= "agent_mon_obj.gif"; //"agent_mon.gif";//$NON-NLS-1$
  public static final String IMG_UI_RUN_AGENT  		= "agent_run_obj.gif";//"agent_run.gif";    //$NON-NLS-1$         
  public static final String IMG_UI_STOP_AGENT 		= "agent_stop_obj.gif";//"agent_stop.gif";//$NON-NLS-1$
  public static final String IMG_FILTER_LOG_AGENT 	= "agent_log_obj.gif";//"filter_log.gif";//$NON-NLS-1$
  public static final String IMG_FILTER_PROF_AGENT 	= "agent_prof_obj.gif";//"filter_prof.gif";//$NON-NLS-1$
  public static final String IMG_ACT_ATTACH 			= "attachtrace_wiz.gif";//"act_attach.gif";//$NON-NLS-1$
  public static final String IMG_ACT_LAUNCH 			= "launchtrace_wiz.gif";//"act_launch.gif";//$NON-NLS-1$
  public static final String IMG_ACT_TRACE 			= "trace_co.gif";//"trace.gif";//$NON-NLS-1$
  public static final String IMG_CLEAR_CONSOLE 		= "clear_co.gif";//$NON-NLS-1$
  public static final String IMG_UI_DETACHED_AGENT	= "agent_detach_obj.gif";//"agent_detach.gif";//$NON-NLS-1$
  public static final String IMG_TERMINATE 			= "terminate_co.gif";//"terminate.gif";  //$NON-NLS-1$
  public static final String IMG_OPTIONS 			= "options_obj.gif";//"terminate.gif";  //$NON-NLS-1$
  public static final String IMG_IMPORT 				= "import_wiz.gif";//$NON-NLS-1$
  public static final String IMG_EXPORT	 			= "export_wiz.gif";//$NON-NLS-1$
  public static final String IMG_REFRESH		 		= "refresh.gif";//$NON-NLS-1$
  public static final String IMG_SAVE		 			= "save.gif";//$NON-NLS-1$
  public static final String IMG_LINK_WITH_VIEWER       = "synced.gif";//$NON-NLS-1$
  public static final String IMG_PROFILE_TAB            = "profile_obj.gif";//$NON-NLS-1$
  
  public static final String IMG_SUSPEND 			= "suspend_co.gif";//"terminate.gif";  //$NON-NLS-1$
  public static final String IMG_RESUME 			    = "resume_co.gif";//"terminate.gif";  //$NON-NLS-1$
  public static final String IMG_UPDATEVIEWS			= "updateviews_co.gif";//"terminate.gif";  //$NON-NLS-1$

  public static final String IMG_UI_WZ_EDITPROFSET	= "profset_wiz.gif";//"profset_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_IMPORT_PROF	= "import_profilefile_wiz.gif";//"import_profilefile_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_NEWJPRJ 		= "newjprj_wiz.gif";//"newjprj_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_NEWMON 		= "newmon_wiz.gif";//"newmon_wiz.gif";  //$NON-NLS-1$
  public static final String IMG_UI_WZ_NEWNODE 		= "newnode_wiz.gif";//"newnode_wiz.gif"; //$NON-NLS-1$ 
  public static final String IMG_UI_WZ_LAUNCH 		= "launch_wiz.gif";//"launch_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_ATTACH 		= "attach_wiz.gif";//"attach_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_MON_PROP 		= "mon_prop_wiz.gif";//"mon_prop_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_NODE_PROP 	= "node_prop__wiz.gif";//"node_prop__wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_PROC_PROP 	= "proc_prop_wiz.gif";//"proc_prop_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_WZ_AGENT_PROP 	= "agent_prop_wiz.gif";//"agent_prop_wiz.gif";//$NON-NLS-1$
  public static final String IMG_UI_FOLDER    		= "folder.gif"; //"monitor.gif";//$NON-NLS-1$

  /*
   * Available cached Images.
   */		
  public static final ImageDescriptor DESC_IMG_UI_QUESTION   	= createManaged(T_OBJ,IMG_UI_QUESTION);
  public static final ImageDescriptor DESC_IMG_FILTER_ENABLED  	= createManaged(T_OBJ,IMG_FILTER_ENABLED);  
  public static final ImageDescriptor DESC_IMG_FILTER_DISABLED	= createManaged(T_OBJ,IMG_FILTER_DISABLED);
  public static final ImageDescriptor DESC_IMG_FILTER         	= createManaged(T_OBJ,IMG_FILTER);  
  public static final ImageDescriptor DESC_IMG_UI_MONITOR    	= createManaged(T_OBJ,IMG_UI_MONITOR); //"monitor.gif";
  public static final ImageDescriptor DESC_IMG_UI_FOLDER      	= createManaged(T_OBJ,IMG_UI_FOLDER); //"monitor.gif";
  
  public static final ImageDescriptor DESC_IMG_UI_NODE       	= createManaged(T_OBJ,IMG_UI_NODE); //"node.gif";   
  public static final ImageDescriptor DESC_IMG_UI_CLASS       	= createManaged(T_OBJ,IMG_UI_CLASS); //"class.gif";
  public static final ImageDescriptor DESC_IMG_UI_PROCESS    	= createManaged(T_OBJ,IMG_UI_PROCESS);//"process.gif";
  public static final ImageDescriptor DESC_IMG_UI_AGENT			= createManaged(T_OBJ, IMG_UI_AGENT);
  public static final ImageDescriptor DESC_IMG_UI_MON_AGENT  	= createManaged(T_OBJ,IMG_UI_MON_AGENT); //"agent_mon.gif";
  public static final ImageDescriptor DESC_IMG_UI_RUN_AGENT  	= createManaged(T_OBJ,IMG_UI_RUN_AGENT);//"agent_run.gif";             
  public static final ImageDescriptor DESC_IMG_UI_STOP_AGENT 	= createManaged(T_OBJ,IMG_UI_STOP_AGENT);//"agent_stop.gif";
  public static final ImageDescriptor DESC_IMG_FILTER_LOG_AGENT 	= createManaged(T_OBJ,IMG_FILTER_LOG_AGENT);
  public static final ImageDescriptor DESC_IMG_FILTER_PROF_AGENT  = createManaged(T_OBJ,IMG_FILTER_PROF_AGENT);
  public static final ImageDescriptor DESC_IMG_CLEAR_CONSOLE 	= createManaged(T_OBJ,IMG_CLEAR_CONSOLE);
  public static final ImageDescriptor DESC_IMG_UI_DETACHED_AGENT  = createManaged(T_OBJ,IMG_UI_DETACHED_AGENT);//"agent_detach.gif";
  public static final ImageDescriptor DESC_IMG_OPTIONS		 	= createManaged(T_OBJ,IMG_OPTIONS);
  public static final ImageDescriptor DESC_IMG_PROFILE_TAB      = createManaged(T_OBJ,IMG_PROFILE_TAB);

  public static final ImageDescriptor DESC_IMG_UI_WZ_EDITPROFSET= createManaged(T_WIZBAN,IMG_UI_WZ_EDITPROFSET);//"profset_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_IMPORT_PROF= createManaged(T_WIZBAN,IMG_UI_WZ_IMPORT_PROF);//"import_profilefile_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_NEWJPRJ 	= createManaged(T_WIZBAN,IMG_UI_WZ_NEWJPRJ);//"newjprj_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_NEWMON 		= createManaged(T_WIZBAN,IMG_UI_WZ_NEWMON);//"newmon_wiz.gif";  
  public static final ImageDescriptor DESC_IMG_UI_WZ_NEWNODE 	= createManaged(T_WIZBAN,IMG_UI_WZ_NEWNODE);//"newnode_wiz.gif";  
  public static final ImageDescriptor DESC_IMG_UI_WZ_LAUNCH 		= createManaged(T_WIZBAN,IMG_UI_WZ_LAUNCH);//"launch_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_ATTACH 		= createManaged(T_WIZBAN,IMG_UI_WZ_ATTACH);//"attach_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_MON_PROP 	= createManaged(T_WIZBAN,IMG_UI_WZ_MON_PROP);//"mon_prop_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_NODE_PROP 	= createManaged(T_WIZBAN,IMG_UI_WZ_NODE_PROP);//"node_prop__wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_PROC_PROP 	= createManaged(T_WIZBAN,IMG_UI_WZ_PROC_PROP);//"proc_prop_wiz.gif";
  public static final ImageDescriptor DESC_IMG_UI_WZ_AGENT_PROP 	= createManaged(T_WIZBAN,IMG_UI_WZ_AGENT_PROP);//"agent_prop_wiz.gif";
  
  protected static Hashtable _images;
  protected static Hashtable _imageDescriptors; 

public static Image getImage(String name)
{
	return (Image)_images.get(name);
}

public static ImageDescriptor getImageDescriptor(String name)
{
	return (ImageDescriptor) _imageDescriptors.get(name);
}

private static ImageDescriptor createManaged(String prefix, String name) {
	try {
		ImageDescriptor result= ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	
		if(_images == null || _imageDescriptors == null)
		{
			_images = new Hashtable();
			_imageDescriptors = new Hashtable();		
		}
			
		_imageDescriptors.put(name, result);
	    _images.put(name, result.createImage());
		return result;
			
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}

public static void setImageDescriptors(IAction action, String type, String relPath) {
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{
			action.setDisabledImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{	
			action.setHoverImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	action.setImageDescriptor(create("e" + type, relPath)); //$NON-NLS-1$
}

private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
	if (fgIconBaseURL == null)
		throw new MalformedURLException();

	StringBuffer buffer;
    if (prefix!=null) 
    {
		buffer= new StringBuffer(prefix);
		buffer.append('/');
		buffer.append(name);
    }
    else 
    {
    	buffer= new StringBuffer(name);
    }
	return new URL(fgIconBaseURL, buffer.toString());
}

private static ImageDescriptor create(String prefix, String name) {
	try {
		return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}

public static void shutdown()
{
	if(_images == null)
	  return;
	
	for (Iterator e = _images.values().iterator(); e.hasNext();) {
		Object next = e.next();
		if (next instanceof Image && !((Image)next).isDisposed())
		{
			((Image)next).dispose();
		}
	}

	_images.clear();
	_images = null;
	_imageDescriptors.clear();
	_imageDescriptors = null;
}

}
