/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * This class provides static methods for some of the
 * very used IString operations
 */

public class HyadesUtil
{
	/**
	 * Test the RAC connection on a host with given port number
	 */
	public static final int CONNECTION_SUCCESS = 0;
	public static final int CONNECTION_CONTROLLER_ERROR = 1;
	public static final int CONNECTION_HOST_ERROR = 2;
	public static final int CONNECTION_PORT_ERROR = 3;
	
  private static StringBuffer tmpBuffer = new StringBuffer();

   // change all occurrences of oldPat to newPat
   public  static String change(String in, String oldPat, String newPat)
   {
	  if (oldPat.length() == 0)
		 return in;
	  if (oldPat.length() == 1 && newPat.length() == 1)
		 return in.replace(oldPat.charAt(0), newPat.charAt(0));

	  int lastIndex = 0;
	  int newIndex = 0;
	  tmpBuffer.setLength(0);
	  
	  for(;;)
	  {
		 newIndex = in.indexOf(oldPat, lastIndex);
		 if (newIndex != -1)
		 {
			tmpBuffer.append(in.substring(lastIndex, newIndex)).append(newPat);
			lastIndex = newIndex + oldPat.length();
		 }
		 else
		 {
			tmpBuffer.append(in.substring(lastIndex));
			break;
		 }
	  }
	  return tmpBuffer.toString();
   }   
         /**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCAgent
 */
public static String getAgentName(TRCAgentProxy agent)
{
	String type = agent.getType();
	String name = agent.getName();
	if(name == null)
	  name = "";
	  
	if(type.equals(HyadesConstants.PROFILE_AGENT_TYPE))
	{
		if(!name.equals(HyadesConstants.J2EE_AGENT_NAME))
			name = UIPlugin.getResourceString("TRACE_NAME");
	}
	else if(type.equals(HyadesConstants.LOG_AGENT_TYPE))
	{
			if(name.equals(""))
				name = UIPlugin.getResourceString("LOG_NAME");
	}
	 	
	if (agent.getStartTime() > 0)
	{
		Date date = new Date((long)agent.getStartTime() * 1000);
		String timestamp = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM).format(date);
		name += " (" + timestamp + ")";
	}
	
	return name;
}
/**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * Form: processName at hostName [PID: processID]
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCProcess
 */
public static String getProcessName(TRCProcessProxy process)
{
	tmpBuffer.setLength(0);
	if (process.getName().length() == 0) tmpBuffer.append("unknown");
	else tmpBuffer.append(process.getName());
	
	return tmpBuffer.append(" "+UIPlugin.getResourceString("STR_AT")+" ").append(process.getNode().getName()).append(" [ PID:").append(process.getPid()).append(" ]").toString();

}
   public static String getAgentLabel(TRCAgentProxy a)
   {
   	  tmpBuffer.setLength(0);
   	  
	  if (a.isActive() && a.isMonitored()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_MONITORED"));	  	        
	  else if (a.isActive() && a.isAttached()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_ATTACHED"));
	  else if (a.isActive()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_DETACTED"));	  
	  else tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_TERMINATED"));
	  
	  if(a.isCollectionData())
	      tmpBuffer.append(UIPlugin.getResourceString("STR_COLLECTING")).append(">");
	  else
	      tmpBuffer.append(">");    
	  	  
	  return tmpBuffer.toString();   	  
   }  
          
   public static int testConnection(String host, String port,boolean message, Shell shell)
   {
	   if (host == null || host.trim() == "" || port == null || port.trim() == "")
	   {
		   String text = UIPlugin.getResourceString("INVALID_HOST");
		   Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);
		   ErrorDialog.openError(shell,UIPlugin.getResourceString("STR_TITLE_MSG")
		               ,UIPlugin.getResourceString("CONNECT_ERROR_"),err);
		
		   return CONNECTION_HOST_ERROR;
	   }
	
	   IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();	
	   ConnectUtil util = new ConnectUtil(host, port, store.getString(HyadesConstants.SECURE_USERID), UIPlugin.getDefault());
	   int result = util.connect();
	   if(result == ConnectUtil.CONNECTION_SUCCESS)
	   {//store the user id
		   store.setValue(HyadesConstants.SECURE_USERID, util.getUserId());
		
		   if(message)
		   {
			   String text = UIPlugin.getResourceString("CONNECTION_SUCCESS_TEXT");
			   MessageDialog.openInformation(shell,UIPlugin.getResourceString("STR_HYADES_MSG"),text);
		   }
		
	   }
	
	   return result;
   }
  
   public static IResource getSelectionFolder(Object selection)
   {
	   if(selection != null)
	   {
		   
		   if(selection instanceof IResource)
			  return (IResource)selection;
		   
		   if(selection instanceof EObject)
		   {
			   String strPath = TString.resourcePath(((EObject)selection).eResource().getURI());
			   return UIPlugin.getPluginWorkbench().getRoot().findMember((new Path(strPath)).removeLastSegments(1));
		   }
		   if (selection instanceof INavigatorItem)
		   	   return getSelectionFolder(((INavigatorItem)selection).getParent());
	   }
	
	   return null;	
   }
  
  public static IResource getSelectionFolder(INavigator viewer){ 
		if(!viewer.getStructuredSelection().isEmpty())
  			return getSelectionFolder(viewer.getStructuredSelection().getFirstElement());
  		
  		return null;
  }
  
  public static void cleanupResources(String navigatorID){

	ProfileEvent event = new ProfileEvent();
	event.setSource(null);
	event.setType(ProfileEvent.CLEAN_UP);
	UIPlugin.getDefault().notifyProfileEventListener(event);

	IWorkbenchPage page = null;
	IWorkbenchWindow[] windows = UIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
	for (int i = 0; i < windows.length; i++) {
		IWorkbenchWindow window = windows[i];
		IWorkbenchPage[] pages = window.getPages();
		for (int j = 0; j < pages.length; j++) {
			page = pages[j];
			if(page!=null && page.getPerspective()!=null && page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE)){
				break;
			}
		}
	}
	
	if(page!= null){
		if(navigatorID.equals(PDPerspective.ID_PD_NAVIGATOR_VIEW)){
			IViewPart part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
			if(part!=null)
				return;	
		}else
		if(navigatorID.equals(PDPerspective.ID_LOG_NAVIGATOR_VIEW)){
			IViewPart part = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		
			if(part!=null)
				return;
		}

	}

	try {
 			
		boolean modified = false;
		if (HierarchyResourceSetImpl.getInstance().getResources().size() > 0) {
				
			Iterator docs = HierarchyResourceSetImpl.getInstance().getResources().iterator();
			while(docs.hasNext())
			{
				org.eclipse.emf.ecore.resource.Resource res = (org.eclipse.emf.ecore.resource.Resource) docs.next();
				if(res != null && res.isLoaded() && res.isModified())
				{
					modified = true;
					break;
				}
			}
			
			Collection external = NavigatorExtensionUtil.getAllModifiedItems(null);
			boolean externalModified = !external.isEmpty();
			
			if(modified || externalModified)
			{
				String title = UIPlugin.getResourceString("TRACE_MSG");
				String msg = UIPlugin.getResourceString("SAVE_PROJECT_SQ");
				String toggleMsg = UIPlugin.getResourceString("REMEMBER_MY_DECISION");
	
				IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
				String value = store.getString(TraceConstants.SAVE_ON_EXIT_KEY);
				if (value == null || "".equals(value)) {
					value = MessageDialogWithToggle.PROMPT;
					store.setValue(TraceConstants.SAVE_ON_EXIT_KEY, value);
				}
				
				boolean saveRequested = false;
				if (MessageDialogWithToggle.PROMPT.equals(value)) {
					saveRequested = MessageDialogWithToggle.openYesNoQuestion(null, title, msg, toggleMsg, false, UIPlugin.getDefault().getPreferenceStore(), TraceConstants.SAVE_ON_EXIT_KEY).getReturnCode() == IDialogConstants.YES_ID;
				}

				if (saveRequested || MessageDialogWithToggle.ALWAYS.equals(value)) {
					if (modified) {
						SaveUtil.saveDocuments();
						IResource res = UIPlugin.getPluginWorkbench().getRoot();
						res.refreshLocal(IResource.DEPTH_INFINITE, null);
					}
					if (externalModified) {
						Iterator i = external.iterator();
						while (i.hasNext())
							((INavigatorItem)i.next()).save(false);
					}
				}
			}
				
//			//clear documents list
//			SaveUtil.getDocuments().clear();
			HierarchyResourceSetImpl.getInstance().getResources().clear();

		}
	} catch (Exception e) {
		HyadesUIPlugin.logError(e);
	}

	TraceUIManager.getTraceUIManager().dispose();
  }
  
  /**
   * 
   * @return selected trace or log object in the Profiling Monitors view or Log Navigator
   */
  public static EObject getMofObject()
  {
  	  Object sel = getNavigatorSelection(getActiveNavigator());
  	  if (sel instanceof EObject)
  	  	return (EObject)sel;
  	  else if (sel instanceof INavigatorItem)
  	  	return (EObject)((INavigatorItem)sel).getData();
  	  else
  	  	return null;
  }
  
  public static INavigator getActiveNavigator()
  {
  	IWorkbenchPage page = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
  	if(page == null || !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) )
  		return null;
  	
  	IViewPart part = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
  	Navigator navigator = null;
  	if(part!=null && ((Navigator)part).isActiveNavigator()){
  		return (INavigator)part;
  	}		
  	
  	part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
  	if(part!=null && ((Navigator)part).isActiveNavigator()){
  		return (INavigator)part;
  	}
  	return null;
  	
  }
  
  public static EObject getNavigatorSelection(INavigator navigator){
			
  	  if(navigator==null)
  	  	return null;
	  IStructuredSelection selection = navigator.getStructuredSelection();
	  if(!selection.isEmpty()){
		  Object obj = ((IStructuredSelection)selection).getFirstElement();
				
		  if(obj != null) {
		  	if (obj instanceof EObject)
		  		return (EObject)obj;
		  	else if (obj instanceof INavigatorItem)
		  		return (EObject)((INavigatorItem)obj).getData();
		  }
	  }					

	  return null;
	
  }
  
  /**
   * @return the object that should be viewed
   * For example, if the process node is selected, the view should display
   * the profiling data if trace collects profiling data
   * Returns the agent if there is only one log agent
   * 
   */
  public static EObject getObjectToView(EObject selObject) {

	  if (selObject == null)
		  return selObject;

	  List list =null;
		
	  if(selObject instanceof TRCMonitor){

		  list = getLogObjectInMonitor((TRCMonitor)selObject);
			
	  }else if(selObject instanceof TRCNode){
			
		  list = getLogObjectInNode((TRCNode)selObject);
		
	  }else if (selObject instanceof TRCProcessProxy) {

		  list = getLogAgentInProcess((TRCProcessProxy)selObject); 
			
	  }
		
	  if(list!=null && list.size()==1){
		  return (EObject)list.get(0);
	  }
	  return selObject;
  }
	
  public static List getLogObjectInMonitor(EObject selObject){

	  java.util.List nodes = ((TRCMonitor)selObject).getNodes();
	  TRCNode node = null;

	  int size = nodes.size();
	  int nrOfNodes = 0;
	  List object_list = new ArrayList();
	  List list;		

	  for(int i=0; i < size && nrOfNodes < 2;i++){		
		  node = (TRCNode)nodes.get(i);
		  if(node==null){
			  continue;
		  }else{	
				
			  list = getLogObjectInNode(node); 
			  if(list.size()>=1){
				  nrOfNodes++;					
				  object_list.add(node);
			  }
		  }
			
	  }
		
	  if(object_list.size()==1){
		  list = getLogObjectInNode((TRCNode)object_list.get(0));
		  if(list.size()==1){
			  object_list.clear();
			  object_list.add(list.get(0));
		  }
	  }
		
	  return object_list;
  }
	
  public static List getLogObjectInNode(EObject selObject){

	  List processes = ((TRCNode)selObject).getProcessProxies();
	  TRCProcessProxy process = null;
	  int nrOfProcesses = 0;
	  int size = processes.size();
	  List list;
	  List object_list = new ArrayList();

	  for(int i=0; i < size && nrOfProcesses < 2;i++){		
		  process = (TRCProcessProxy)processes.get(i);
		  if(process!=null){
			  list = getLogAgentInProcess(process);
			  if(list.size()>=1){
				  nrOfProcesses++;
				  object_list.add(process);
			  }
		  }else{
			  continue;								
		  }
	  }
		
	  if(object_list.size()==1){
		  list = getLogAgentInProcess((TRCProcessProxy)object_list.get(0));
		  if(list.size()==1){
			  object_list.clear();
			  object_list.add(list.get(0));
		  }
			
	  }
	  return object_list;
  }
	
  public static List getLogAgentInProcess(EObject selObject){

	  int nrOfAgents = 0;
	  List agents = ((TRCProcessProxy)selObject).getAgentProxies();
	  int size = agents.size();
	  TRCAgentProxy a = null;
	  List list =  new ArrayList();
		
	  for (int idx = 0; idx < size && nrOfAgents < 2; idx++) {
		  a = (TRCAgentProxy) agents.get(idx);
		  if (a == null || a.eIsProxy())
			  continue;
		  if (a.getType().equals(HyadesConstants.LOG_AGENT_TYPE)) {
			  nrOfAgents++;
			  list.add(a);
		  }
	  }
		
	  return list;
	
  }
/**
 * @param proxy
 * @return
 */
public static Collection getLogAgents(EObject eObject) {
	
	List log_agents = new ArrayList();
	Collection processes = null;
	
	if(eObject instanceof CorrelationContainerProxy){
		log_agents.addAll(((CorrelationContainerProxy)eObject).getCorrelatedAgents());
	}
	if(eObject instanceof TRCMonitor){
		processes = getProcesses((TRCMonitor)eObject);
	}else if (eObject instanceof TRCNode){
		processes = ((TRCNode)eObject).getProcessProxies();
	}else if(eObject instanceof TRCProcessProxy){
		processes = new ArrayList(1);
		processes.add(eObject);
	}else if(eObject instanceof TRCAgentProxy && ((TRCAgentProxy)(eObject)).getType().equals(HyadesConstants.LOG_AGENT_TYPE)){
		log_agents.add(eObject);
	}
	if(processes!=null){
		TRCProcessProxy process = null;
		for (Iterator iter = processes.iterator(); iter.hasNext();) {
			process = (TRCProcessProxy) iter.next();
			if(process!=null){
				Collection agents = process.getAgentProxies();
				TRCAgentProxy agentProxy = null;
				for (Iterator iterator = agents.iterator();
					iterator.hasNext();
					) {
					agentProxy = (TRCAgentProxy) iterator.next();
					if(agentProxy!=null && agentProxy.getType().equals(HyadesConstants.LOG_AGENT_TYPE)){
						log_agents.add(agentProxy);
					}					
				}
			}			
		}
	}
	return log_agents;
}
/**
 * @param monitor
 * @return
 */
public static Collection getProcesses(TRCMonitor monitor) {

	List nodes = monitor.getNodes();
	List processes = new ArrayList();
	int nodes_size = nodes.size();
	for(int i=0; i < nodes_size; i++){
		List list = ((TRCNode)nodes.get(i)).getProcessProxies();
		processes.addAll(list);
	}
	return processes;
}
/**
 * @param project
 * @return
 */
public static List getResources(IProject project) {

	List resources = new ArrayList();
	IResource[] members;
	try {
		members = project.members();
		for(int idx=0; idx<members.length; idx++)
		{
			IResource member = members[idx];
			if(member== null || !member.exists())
			  continue;
				  
			if(member instanceof IFile && ((IFile)member).getFileExtension() != null &&
			((IFile)member).getFileExtension().equals(TraceConstants.MONITOR_EXT)){
				resources.add(member);
			}
	
		}
	} catch (CoreException e) {
		e.printStackTrace();
	}
	
	return resources;
}
/**
 * @param resource
 * @param resourceSet
 * @return
 */
public static List getMonitors(IResource resource, ResourceSet resourceSet) {
	List monList = new ArrayList();
	Resource res = null;
	try
	{
		String monPath = resource.getFullPath().toString();	
		String name = monPath;
	
		res = resourceSet.getResource(URI.createURI("platform:/resource"+ name), true);
			
		List ext = res.getContents();
		Iterator i = ext.iterator();
		while (i.hasNext())
		{
			Object obj = i.next();
			if (obj instanceof TRCMonitor){
				monList.add(obj);
			}
		} 
	   
	}
	catch (Exception e) {
	   e.printStackTrace();
	}
			
	return monList;

}
}

