/*******************************************************************************
 * Copyright (c) 2004 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProcessWrapperRunnable implements IRunnableWithProgress {

	private Object parent;

	private Object[] children = null;

	private ILaunchConfiguration _conf;

	private boolean logAgentsEnabled;

	private boolean profileAgentsEnabled;

	private ArrayList fAgentTypeList;

	public ProcessWrapperRunnable(Object p_parent, ILaunchConfiguration c) {
		parent = p_parent;
		_conf = c;

		logAgentsEnabled = UIPlugin.getDefault().getPreferenceStore()
				.getBoolean(TraceConstants.LOG_OPTION_KEY);
		profileAgentsEnabled = UIPlugin.getDefault().getPreferenceStore()
				.getBoolean(TraceConstants.PROF_OPTION_KEY);

		fAgentTypeList = null;
	}

	private ArrayList getAgentTypeList() {
		if (fAgentTypeList == null) {
			fAgentTypeList = new ArrayList();
			fAgentTypeList.add("Logging");
		}
		return fAgentTypeList;

	}

	private boolean isDisplay(Object obj) {
		if (obj instanceof Process) {
			Enumeration agents = ((Process) obj).listAgents();

			while (agents.hasMoreElements()) {
				if (isDisplay(agents.nextElement()))
					return true;
			}
			return false;
		} else if (obj instanceof Agent) {
			Agent agent = (Agent) obj;
			if (agent.isActive()) {
				if (logAgentsEnabled
						&& agent.getType()
								.equals(TraceConstants.LOG_AGENT_TYPE)
						&& !agent.isAttached()) {
					return true;
				} else if (profileAgentsEnabled
						&& agent.getType().equals(
								TraceConstants.PROFILE_AGENT_TYPE)
						&& !agent.isAttached()) {
					return true;
				} else {
					ArrayList agentList = getAgentTypeList();
					for (int i = 0; i < agentList.size(); i++) {
						if (!(agent.getType()
								.equals(TraceConstants.LOG_AGENT_TYPE))
								&& (agent.getType().equals((String) (agentList
										.get(i))))) {
							return true;
						}
					}

				}
			}

			return false;
		}
		return true;
	}

	public void run(IProgressMonitor pm) {

		if (parent instanceof ProcessTreeItem) {
			ProcessTreeItem pti = (ProcessTreeItem) parent;

			if (pti.getData() == null) {
				Object[] childrenObjs = ProfileAttachDelegate
						.getNodeConfiguration(_conf).toArray();
				if (childrenObjs.length == 0) {
					children = null;
				} else {
					Vector childrenV = new Vector();
					for (int i = 0; i < childrenObjs.length; i++) {
						if (isDisplay(childrenObjs[i]))
							childrenV.addElement(new ProcessTreeItem(
									childrenObjs[i], pti));
					}

					children = childrenV.toArray();
				}
			} else if (pti.getData() instanceof Process) {

				Process process = (Process) pti.getData();
				Enumeration agents = process.listAgents();

				Vector childrenV = new Vector();

				while (agents.hasMoreElements()) {
					Object agent = agents.nextElement();
					if (isDisplay(agent))
						childrenV.addElement(new ProcessTreeItem(agent, pti));
				}
				children = childrenV.toArray();
			} else {
				children = null;
			}
		}
	}

	public Object[] getChildren() {
		if (children != null) {
			return children;
		}
		return new Object[0];
	}
}

