/*******************************************************************************
 * Copyright (c) 2003 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class ProfileAgentsTab extends AbstractLaunchConfigurationTab {
	private ILaunchConfiguration _conf;

	private DoubleCTree _list;

	private boolean _initialized = false;

	public void createControl(Composite parent) {
		_initialized = false;

		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_list = new DoubleCTree(content, SWT.NULL, UIPlugin
				.getResourceString("STR_LIST_AGENTS"), UIPlugin
				.getResourceString("STR_LIST_SOURCE"), UIPlugin
				.getResourceString("STR_LIST_TARGET"));
		_list.addListener(new Listener() {
			public void handleEvent(Event event) {
				// the list changed; update
				updateLaunchConfigurationDialog();
			}
		});

		Button refresh = new Button(content, SWT.PUSH);
		refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
		refresh.setToolTipText(UIPlugin
				.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
		refresh.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				_list.initialize();
			}
		});

		WorkbenchHelp.setHelp(_list.getControl(), UIPlugin.getPluginId()
				+ ".atlp0002");
		WorkbenchHelp.setHelp(refresh, UIPlugin.getPluginId() + ".atlp0000");
		WorkbenchHelp.setHelp(parent, UIPlugin.getPluginId() + ".atlp0002");

	}

	public boolean isValid(ILaunchConfiguration conf) {
		setErrorMessage(null);
		setMessage(null);

		if (conf != null && !_list.treesLoaded()
				&& _list.getAttributeProcesses().size() > 0) {
			return true;
		}

		if (_list.getSelectedItemsForProfiling().length == 0) {
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
			return false;
		}

		return true;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
	}

	public void initializeFrom(ILaunchConfiguration conf) {
		_conf = conf;

		_list.initializeLaunchConfiguration(_conf);

		if (getControl().isVisible() && !_initialized) {
			_list.initialize();
			_initialized = true;
		}

	}

	public void performApply(ILaunchConfigurationWorkingCopy wc) {
		if (_initialized)
		{
			List list = new ArrayList();
			Object[] targetItems = _list.getSelectedItemsForProfiling();
	
			for (int i = 0; i < targetItems.length; ++i)
				list.add((new ProfileAttachDelegate.ProcessAttribute(
						(Process) ((ProcessTreeItem) targetItems[i]).getData()))
						.getAttributeString());
	
			wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, list);
		}
	}

	public String getName() {
		return UIPlugin.getResourceString("TAB_NAME_AGENTS");
	}

	public Image getImage() {
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_AGENT);
	}

	void reset() {
		_initialized = false;
		_list.removeAll();
	}
}