/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;

/**
 * The execution arguments for running a Java VM. The execution arguments are
 * separated into two parts: arguments to the VM itself, and arguments to the Java 
 * main program.
 */
public class TraceArguments
{
	private String fHostName;		
	private String fClassName;
	private String fClassPath;
	private String fParameters;
	private String fVMArgs;
	private int fPortNumber;
	private String[] fEnvionmentVariable;
	private boolean fAutoMonitoring;
	
	private Date fTimestamp;
	private String fId = "";

	private String   fPath;
	private String   fLocation; //process home directory
	private String   profileFile = null; //null when not to profile file

	/**
	 * Creates a new execution arguments object.
	 *
	 */
	public TraceArguments(String className)
	{
		fClassName = className;
		fTimestamp = new Date();
	}
	/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getClassName()
{
	return fClassName;
}

public String[] getEnvironmentVariable()
{
	return fEnvionmentVariable;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getClassPath()
{
	return fClassPath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getHostName()
{
	return fHostName;
}

public int getPortNumber()
{
	return fPortNumber;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:18:31 PM)
 * @return java.lang.String
 */
public String getId()
{
	return fId;	
}
/**
 * Insert the method's description here.
 * Creation date: (9/7/2001 5:41:24 PM)
 */
public String getLocation()
{
	return fLocation;
}
	/**
	 * Returns the program arguments.
	 *
	 * @return the program arguments
	 */
	public String getParameters()
	{
		return fParameters;
	}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:16:51 PM)
 * @return java.lang.String
 */
public String getPath() {
	return fPath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:24:13 PM)
 * @return Date
 */
public Date getTimestamp() {
	return fTimestamp;
}
/**
	 * Returns the program arguments.
	 *
	 * @return the program arguments
	 */
	public String getVMArguments()
	{
		return fVMArgs;
	}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setClassName(String name)
{
	fClassName = name;
}


public void setEnvironmentVariable(String[] envVar)
{
	fEnvionmentVariable = envVar;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setClassPath(String name)
{
	fClassPath = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setHostName(String name)
{
	fHostName = name;		
}

public void setPortNumber(int portNumber)
{
	fPortNumber = portNumber;		
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:16:37 PM)
 * @param id java.lang.String
 */
public void setId(String id)
{
	fId = id;
}
/**
 * Insert the method's description here.
 * Creation date: (9/7/2001 5:40:51 PM)
 * @param location java.lang.String
 */
public void setLocation(String location)
{
	fLocation = location;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setParameters(String name)
{
	fParameters = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:16:22 PM)
 * @param path java.lang.String
 */
public void setPath(String path)
{
	fPath = path;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setVMArguments(String name)
{
	fVMArgs = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:11:09 PM)
 */
public String toString()
{
	return fClassName;
	
	
}

	/**
	 * Determine if profile data is to a file.
	 */
	public boolean isToProfileFile()
	{
		return !(profileFile==null || profileFile.trim().equals(""));
	}
	
	/**
	 * Returns the profileFile.
	 * @return String
	 */
	public String getProfileFile() {
		return profileFile;
	}

	/**
	 * Sets the profileFile.
	 * @param profileFile The profileFile to set
	 */
	public void setProfileFile(String profileFile) {
		this.profileFile = profileFile;
	}

	/**
	 * @return
	 */
	public boolean isAutoMonitoring() {
		return fAutoMonitoring;
	}

	/**
	 * @param b
	 */
	public void setAutoMonitoring(boolean b) {
		fAutoMonitoring = b;
	}
}
