/*******************************************************************************
 * Copyright (c) 2004 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.swt.graphics.Image;

public class ProcessTreeItem implements IAdaptable {
	private Object _adapter;

	private Object _data;
	
	private ProcessTreeItem _parent;

	public ProcessTreeItem(Object data, ProcessTreeItem parent) {
		_data = data;
		_parent = parent;
	}

	public Object getData() {
		return _data;
	}
	
	public ProcessTreeItem getParent()
	{
		return _parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		return _adapter;
	}

	public void setAdapter(Object adapter) {
		_adapter = adapter;
	}

	public String getLabelText() {
		if (_data == null)
			return "";
		else if (_data instanceof Process) {
			String text = ((Process) _data).getName();
			if (text == null) {
				text = ((Process) _data).getExecutable();
			}

			try {
				text = text + "[PID:" + ((Process) _data).getProcessId() + "]";
			} catch (InactiveProcessException exc) {
			}
			return text;
		} else if (_data instanceof Agent) {
			return ((Agent) _data).getName();
		}

		return "";
	}

	public Image getImage() {
		if (_data == null)
			return null;
		else if (_data instanceof Process) {
			return PDPluginImages.getImage(PDPluginImages.IMG_UI_PROCESS);
		} else if (_data instanceof Agent) {
			return PDPluginImages
					.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT);
		}

		return null;
	}

}
