/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;


public class TreeLabelProvider extends LabelProvider {
	private Hashtable iconList;

	public TreeLabelProvider(ImageDescriptor[] descList) {
		iconList = new Hashtable();
		for(int i = 0; i < descList.length; i ++) {
			if (iconList.containsKey(descList[i]) == false) {
				iconList.put(descList[i], descList[i].createImage());
			}
		}
	}

	public String getText(Object element) {
		if (element instanceof IProfilingSetType) {
			return ((IProfilingSetType)element).getName();
		} else if(element instanceof IProfilingSetTypeGroup){
			return ((IProfilingSetTypeGroup)element).getName();
		}
		return element.toString();
	}

	public Image getImage(Object element) {
		ImageDescriptor imageDesc = null;
		if (element instanceof IProfilingSetType) {
			imageDesc = ((IProfilingSetType)element).getImage();
		}
		else if(element instanceof IProfilingSetTypeGroup){
			imageDesc = ((IProfilingSetTypeGroup)element).getIcon();
		}			
		if(imageDesc == null) {
			return null;
		}
		
		return (Image)iconList.get(imageDesc); 
	}

	public void dispose() {
		Iterator list = iconList.keySet().iterator();
		while(list.hasNext()) {
			((Image)iconList.get(list.next())).dispose();
		}
		iconList.clear();
		iconList = null;
    }
}

