/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class CBEFilterUI extends LogAnalyzerUI {

	private Button _sevOne;
	private Button _sevTwo;
	private Button _sevThree;
	private String _filter;
	private String _sevFilter;
	private String _title;
	private Composite result;

	public CBEFilterUI() {
		super();
		
	}
	public Control createControl(Composite parent) {
				
		GridData data;
		GridLayout blayout;
		result = (Composite)super.createControl(parent);
		setDescription(LogUIPlugin.getResourceString("STR_COL_DLG_TEXT"));


		Composite sevText = new Composite(result, SWT.NULL);
		data = new GridData();
		data.horizontalSpan = 3;
		sevText.setLayoutData(data);
		blayout = new GridLayout();
		blayout.numColumns = 1;
		sevText.setLayout(blayout);

		Label label = new Label(sevText, SWT.NULL);
		data = new GridData();
		data.horizontalAlignment = GridData.FILL;
		label.setLayoutData(data);
		label.setText(LogUIPlugin.getResourceString("STR_SHOW_LOG_FILTER_TEXT"));

		Composite sevWidget = new Composite(sevText, SWT.NULL);
		data = new GridData();
		data.horizontalSpan = 3;
		sevWidget.setLayoutData(data);
		blayout = new GridLayout();
		blayout.numColumns = 3;
		sevWidget.setLayout(blayout);

		_sevOne = new Button(sevWidget, SWT.CHECK);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_sevOne.setLayoutData(data);
		_sevOne.setText(LogUIPlugin.getResourceString("STR_FILTER_ERROR"));
		
		_sevOne.addSelectionListener(this);

		_sevTwo = new Button(sevWidget, SWT.CHECK);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_sevTwo.setLayoutData(data);
		_sevTwo.setText(LogUIPlugin.getResourceString("STR_FILTER_WARNING"));
		
		_sevTwo.addSelectionListener(this);		

		_sevThree = new Button(sevWidget, SWT.CHECK);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_sevThree.setLayoutData(data);
		_sevThree.setText(LogUIPlugin.getResourceString("STR_FILTER_INFO"));
		
		_sevThree.addSelectionListener(this);		

		populateList();
		//populateList(_wasList, _wasData, null);
		populateSeverity();

		WorkbenchHelp.setHelp(_sevOne, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_ERROR);
		WorkbenchHelp.setHelp(_sevTwo, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_WARNING);
		WorkbenchHelp.setHelp(_sevThree, ContextIds.ACTLOG_VIEW_DIALOG_FILTER_INFORMATION);

		return result;
	}

	protected void populateList() {

		_pdList.removeAll();
		for (int idx = 0; idx < _pdData.size(); idx++) {
			ColumnData data = (ColumnData) _pdData.get(idx);

			TableItem item = new TableItem(_pdList, SWT.NONE);
			item.setText(data.name());
			item.setChecked(data.visible() == true);
			item.setData(data);
		}

		if (_pdList.getItemCount() > 0) {
			_pdList.select(0);
			_moveDown.setEnabled(true);
		}
	}
	private void populateSeverity() {
		_sevOne.setSelection(true);
		_sevTwo.setSelection(true);
		_sevThree.setSelection(true);

		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		String filters = store.getString(LogUIConstants.PD_SEV_OPTIONS);

		if (filters != null) {
			int idx = filters.indexOf(" ");
			if (idx != -1) {
				String data = filters.substring(0, 1);
				_sevOne.setSelection(data.equals("1"));

				filters = filters.substring(idx + 1);
			}
			idx = filters.indexOf(" ");
			if (idx != -1) {
				String data = filters.substring(0, 1);
				_sevTwo.setSelection(data.equals("1"));

				filters = filters.substring(idx + 1);
			}
			idx = filters.indexOf(" ");
			if (idx != -1) {
				String data = filters.substring(0, 1);
				_sevThree.setSelection(data.equals("1"));

				filters = filters.substring(idx + 1);
			}

		}

	}
	public void initializeValues(boolean defaultValue) {
				
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		
		String pdFilters = defaultValue ? store.getDefaultString(LogUIConstants.PD_FILTER_OPTIONS):store.getString(LogUIConstants.PD_FILTER_OPTIONS);
		String filterSev = defaultValue ? store.getDefaultString(LogUIConstants.PD_SEV_OPTIONS):store.getString(LogUIConstants.PD_SEV_OPTIONS);
		
		createColumnDataFromString(pdFilters, _pdData);
		
		populateList();
		
				
		if (filterSev.length() > 0) {
			if (filterSev.substring(0, 1).equals("1")){
				_sevOne.setSelection(true);

			}else{
				_sevOne.setSelection(false);
			}
			if (filterSev.substring(2, 3).equals("1")){
				_sevTwo.setSelection(true);
 
			}else{
				_sevTwo.setSelection(false);
			}
			if (filterSev.substring(4, 5).equals("1")){
				_sevThree.setSelection(true);

			}else
				_sevThree.setSelection(false);
		} else {
			_sevOne.setSelection(true);
			_sevTwo.setSelection(true);
			_sevThree.setSelection(true);
		}
		
		if(defaultValue){
			Event e = new Event();
			e.widget = result;
			e.type = SWT.Selection;
			notifyListeners(new SelectionEvent(e));
			 			
		}
	}
	
	public boolean storeValues(IPreferenceStore store) {
		if (!validate(_pdList)) {
			//String title = LogUIPlugin.getResourceString("LOGGING_MESSAGE");
			//String msg = LogUIPlugin.getResourceString("ERR_SELECT_COLS");
			//org.eclipse.jface.dialogs.MessageDialog.openError(_sevOne.getShell(), title, msg);
			_pdData.clear();
			return false;
		}

		loadColumnData(LogUIConstants.PD_FILTER_OPTIONS, _pdData, _pdList, store);

						
		String sevFilters = "";
		if (_sevOne.getSelection())
			sevFilters = "1 ";
		else
			sevFilters = "0 ";
		if (_sevTwo.getSelection())
			sevFilters += "1 ";
		else
			sevFilters += "0 ";
		if (_sevThree.getSelection())
			sevFilters += "1 ";
		else
			sevFilters += "0 ";

		// Save the column data template into the preferences.
		LogUIPlugin.getDefault().getPreferenceStore().setValue(
			LogUIConstants.PD_SEV_OPTIONS,
			sevFilters);

		_pdData.clear();

		return true;
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (5/30/2001 4:36:22 PM)
	 */
	private boolean validate(Table _list) {
		boolean valid = false;

		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			TableItem item = _list.getItem(idx);

			if (item.getChecked())
				return true;
		}

		return valid;
	}
	
	/**
	 * @return Composite
	 */
	public Composite getControl() {
		return result;
	}

}