/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.analysis.engine.IAnalysisMonitor;

/**
 * An adapter between the analysis engine's <code>IAnalysisMonitor</code>
 * and Eclipse's <code>IProgressMonitor</code>. Simply forwards
 * all calls from the <code>IAnalysisMonitor</code> to the
 * <code>IProgressMonitor</code>.
 * 
 * @author curtispd
 * @since 3.0
 */
public class ProgressMonitorAdapter implements IAnalysisMonitor {
	private IProgressMonitor _monitor;
	
	/**
	 * Constructs a new adapter.
	 * 
	 * @param monitor the monitor to forward the calls to.
	 */
	public ProgressMonitorAdapter(IProgressMonitor monitor) {
		_monitor = monitor;
	}
	
	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#beginTask(java.lang.String, int)
	 */
	public void beginTask(String name, int totalWork) {
		_monitor.beginTask(name, totalWork);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#done()
	 */
	public void done() {
		_monitor.done();
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#internalWorked(double)
	 */
	public void internalWorked(double work) {
		_monitor.internalWorked(work);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#isCanceled()
	 */
	public boolean isCanceled() {
		return _monitor.isCanceled();
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#setCanceled(boolean)
	 */
	public void setCanceled(boolean value) {
		_monitor.setCanceled(value);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#setTaskName(java.lang.String)
	 */
	public void setTaskName(String name) {
		_monitor.setTaskName(name);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#subTask(java.lang.String)
	 */
	public void subTask(String name) {
		_monitor.subTask(name);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#worked(int)
	 */
	public void worked(int work) {
		_monitor.worked(work);
	}
}
