/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * This interface defines a test deployment mechanism to automatically deploy
 * test artifacts required by test execution to their designated locations.
 * 
 * @author bjiang
 * @since 3.0
 * @deprecated replaced by
 *             {@link org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapterExtended}
 *             so bufError out parameters could be added to all methods
 *  
 */
public interface IExecutionDeploymentAdapter {
    /**
     * The implementation of this method should deploy test artifacts to their
     * corresponding locations. Test artifacts and locations are referenced in
     * the {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}-
     * {@link org.eclipse.hyades.models.common.configuration.CFGLocation}pairs
     * contained in the specified
     * {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}.
     * 
     * @param node
     *            the node to where the test assets shall be deployed.
     * @param deployment
     *            {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}
     *            that contains the
     *            {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}-
     *            {@link org.eclipse.hyades.models.common.configuration.CFGLocation}
     *            pairs to be deployed.
     * @param isStandalone
     *            if this is a standalone execution outside of eclipse.
     */
    public void deployTestAssets(INode node, TPFDeployment deployment,
            boolean isStandalone);

    /**
     * This method provide the point to clean up any test artifacts that were
     * deployed after test execution is finished.
     * 
     * @param node
     *            the node to where the test assets shall be deployed.
     * @param deployment
     *            the same
     *            {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}
     *            that was used to set up the test artifacts.
     * @param isStandalone
     *            if this is a standalone execution outside of eclipse.
     */
    public void cleanUpTestAssets(INode node, TPFDeployment deployment,
            boolean isStandalone);
}