/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui;

import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;

/**
 * Contains utility methods to work with the Hyades UI classes and the wide
 * context constants.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class HyadesUI
{
	/**
	 * Creates an instance of a association mapping registry.
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry createAssociationMappingRegistry()
	{
		return new AssociationMappingRegistry();
	}

	/**
	 * Returns <code>true</code> if and only if the navigator
	 * filter set with the given id is currently enabled. Returns
	 * <code>false</code> if the filter set does not exist.
	 * 
	 * @param id the navigator filter set's unique id
	 * @return <code>true</code> if the filter set is currently
	 *    enabled.
	 * @since 3.0
	 */
	public static boolean isNavigatorFilterSetEnabled(String id) {
		NavigatorFilterSet filter = NavigatorExtensionUtil.getFilterSetElement(id);
		if (filter != null)
			return filter.isEnabled();
		return false;
	}
	
	/**
	 * Enables/disables the navigator filter set with the given id.
	 * Does nothing if the filter set does not exist.
	 * 
	 * @param id the navigator filter set's unique id.
	 * @param value whether or not the filter set should be enabled.
	 * @since 3.0
	 */
	public static void setNavigatorFilterSetEnabled(String id, boolean value) {
		NavigatorFilterSet filter = NavigatorExtensionUtil.getFilterSetElement(id);
		if (filter != null)
			filter.setEnabled(value);
	}
	
	/**
	 * Preference store key, that holds the value for switching to 
	 * prefered/default perspective.
	 * 
	 * Can have one of three values:
	 * <code>MessageDialogWithToggle.PROMPT</code>
	 * <code>MessageDialogWithToggle.ALWAYS</code>
	 * <code>MessageDialogWithToggle.NEVER</code> 
	 * @since 3.1
	 */
	public static final String SWITCH_TO_PERSPECTIVE_KEY = "switch_to_perspective";
}
