/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Abstract extension of the Eclipse's <code>Wizard</code> that defines a common 
 * layout for the Hyades wizards.  The subclasses are supposed to add the pages
 * in the appropriate order and using the correct values for their titles and descriptions.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public abstract class HyadesWizard 
extends Wizard implements IDisposable, IWorkbenchWizard
{
	private IWorkbench workbench;
	private IStructuredSelection selection;

	/**
	 * Constructor for HyadesWizard
	 */
	public HyadesWizard()
	{
		super();
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#dispose()
	 */
	public void dispose()
	{
		workbench = null;
		selection = null;
		super.dispose();
	}
	
	/**
	 * Returns the selection which was passed to <code>init</code>.
	 * @return the selection
	 */
	public IStructuredSelection getSelection()
	{
		return selection;
	}
	
	/**
	 * Returns the workbench which was passed to <code>init</code>.
	 * @return the workbench
	 */
	public IWorkbench getWorkbench()
	{
		return workbench;
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		this.selection = selection;
		this.workbench = workbench;
		
		initPages();
	}
	
	/**
	 * Instantiates the wizard pages provided by this wizard.
	 */
	abstract protected void initPages();

	/**
	 * @see IWizard#createPageControls(Composite)
	 */
	public void createPageControls(Composite parent)
	{
		super.createPageControls(parent);
		setPageHelpIds();
	}

	/**
	 * Place holder for clients to define the help ids of the pages of this 
	 * wizard.
	 */
	protected void setPageHelpIds()
	{
	}	
}
