/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.ui.internal.util.AcadPerspective;
import org.eclipse.hyades.logging.adapter.ui.preferences.AcadEditorPreferencePage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDResourceImpl;

/**
 * This is the central singleton for the Adapter editor plugin.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public final class AcadEditorPlugin extends EMFPlugin {
	
	private static final String extensionPointID = "cbeSchema";
	public static final String cbeName = "CommonBaseEvent";
	protected String identifier;
	
	/**
	 * Keep track of the singleton.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final AcadEditorPlugin INSTANCE = new AcadEditorPlugin();

	/**
	 * Keep track of the singleton.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Implementation plugin;
	
	private HashMap elementMap;
	private HashMap inheritedTypesMap;
	private XSDSchema schema;
	

	/**
	 * Create the instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AcadEditorPlugin() {
		super
		  (new ResourceLocator [] {
		   });
	}

	/**
	 * Returns the singleton instance of the Eclipse plugin.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the singleton instance.
	 * @generated
	 */
	public ResourceLocator getPluginResourceLocator() {
		return plugin;
	}

	/**
	 * Returns the singleton instance of the Eclipse plugin.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the singleton instance.
	 * @generated
	 */
	public static Implementation getPlugin() {
		return plugin;
	}

	/**
	 * The actual implementation of the Eclipse <b>Plugin</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class Implementation extends EclipsePlugin {
		/**
		 * Creates an instance.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @param descriptor the description of the plugin.
		 * @generated
		 */
		public Implementation(IPluginDescriptor descriptor) {
			super(descriptor);

			// Remember the static instance.
			//
			plugin = this;
			plugin.getPluginPreferences().setDefault(AcadEditorPreferencePage.BUFFER_SIZE, AcadEditorPreferencePage.DEFAULT_SIZE);	
		}
	}
	
	public HashMap getCBEElements()
	{
		if(elementMap == null)
		{
			BusyIndicator.showWhile(Display.getCurrent(), new Runnable() {
				public void run() {
					loadCBEPackageInfo();
				}
			});
			
		}
		   		   		   
		return elementMap;    
	}
	
	public void loadCBEPackageInfo()
	{
		XSDSchema schema = getCBESchema();
		
		elementMap = new HashMap();
		inheritedTypesMap = new HashMap();
        
        if(schema == null)
        {    
			String msg = getPlugin().getString("STR_SCHEMA_ERROR");
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					msg,
					null);

			ErrorDialog.openError(Display.getCurrent().getActiveShell(), AcadEditorPlugin.getPlugin().getString("STR_AD_MSG_TITLE"), "", err);

        	return;
        }
          
		EList elems = schema.getElementDeclarations();
		for(int idx=0; idx<elems.size(); idx++)
		{
			XSDElementDeclaration elem = (XSDElementDeclaration)elems.get(idx);
			elementMap.put(elem.getName(), elem);
		}
		
		elems = schema.getTypeDefinitions();
		for(int idx=0; idx<elems.size(); idx++)
		{
			XSDTypeDefinition elem = (XSDTypeDefinition)elems.get(idx);
			
			Object value = inheritedTypesMap.get(elem);
			if(value == null)
				inheritedTypesMap.put(elem, new ArrayList());
				
			XSDTypeDefinition baseType = elem.getBaseType();
			if(baseType != null)
			{
				value = inheritedTypesMap.get(baseType);
				if(value == null)
				{
					ArrayList list = new ArrayList();
					list.add(elem);
					
					inheritedTypesMap.put(baseType, list);
				}
				else
				{
					((ArrayList)value).add(elem);
				}
			}
		}
		
	 }

	protected XSDSchema getCBESchema()
	{
		if(schema != null)
		  return schema;
    	
		IExtensionPoint point = getPlugin().getDescriptor().getExtensionPoint(extensionPointID);

		if (point != null) {
			IConfigurationElement[] elements = point.getConfigurationElements();

			for (int i = 0; i < elements.length; i++) {
				
				IConfigurationElement elem = elements[i];
				
				String schemaName = elem.getAttribute("name");
				if(schemaName == null || schemaName.length() == 0)
				  return null;
				  
				ResourceSet resourceSet = new ResourceSetImpl();
				URI uri = URI.createURI(new StringBuffer(getPlugin().getDescriptor().getInstallURL().toString()).append(schemaName).toString());
				XSDResourceImpl xsdSchemaResource = (XSDResourceImpl)resourceSet.getResource(
						uri, true);

				for (Iterator resources = resourceSet.getResources().iterator(); 
					resources.hasNext(); /* no-op */)
				{
					// Return the first schema object found, which is the main schema 
					//   loaded from the provided schemaURL
					Resource resource = (Resource)resources.next();
					if (resource instanceof XSDResourceImpl)
					{
						XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
						
						schema = xsdResource.getSchema();
						// This returns a org.eclipse.xsd.XSDSchema object
						return schema;
					}
				}

				
			}
		}
    	
		return null;
	}

	public Object getElementDefinitionForType(RuleElementType elem)
	{
		String elementName = elem.getName();
		if(elementName == null)
		  return null;
    	  
		Object cbeObject = AcadEditorPlugin.INSTANCE.getCBEElements().get(elementName);
		if(cbeObject != null)
		{
			return cbeObject;
		}
		else// CBE reference
		{
			EObject container = elem.eContainer();
			ArrayList list = new ArrayList();
			
			while(container != null && container instanceof RuleElementType && cbeObject == null)
			{
				cbeObject = AcadEditorPlugin.INSTANCE.getCBEElements().get(((RuleElementType)container).getName());			
				
				if(cbeObject == null)
				{
					String name = ((RuleElementType)container).getName();				
					list.add(name);					
				}
				container = ((RuleElementType)container).eContainer();	
							
			}
			
			if(cbeObject == null)
			  return null;
			  
			for(int idx=list.size()-1; idx>=0; idx--)
			{
				cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionFromType(((XSDElementDeclaration)cbeObject).getType(), list.get(idx).toString());
				if(cbeObject == null)
				   break;
			}
			
			if(cbeObject != null && cbeObject instanceof XSDElementDeclaration)
				return getElementDefinitionFromType(((XSDElementDeclaration)cbeObject).getTypeDefinition(), elementName);
			else if(cbeObject instanceof XSDTypeDefinition)	
				return getElementDefinitionFromType((XSDTypeDefinition)cbeObject, elementName);
			
		   return null;	
			
					
		}
	}
    
    
		public Object getElementDefinitionFromType(XSDTypeDefinition type, String typeName)
		{
			if(type == null || typeName == null)
			  return null;
			
	//		XSDTypeDefinition type = cbeObject.getTypeDefinition();
			
			if(type instanceof XSDComplexTypeDefinition)
			{
				XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)type;			
				
				if(ctype.isAbstract())
				{//get inherited classes
					
					Object inhList = getInheritedTypes(ctype);
					if(inhList != null)
					{
						ArrayList list = (ArrayList)inhList;
						for(int idx=0; idx<list.size(); idx++)
						{
							XSDTypeDefinition def = (XSDTypeDefinition)list.get(idx);
							if(def.getName().equals(typeName))
							{
								return def;
							}
						}
					}
				}
	
				XSDComplexTypeContent tdef = ctype.getContentType();			
				if(tdef != null && tdef instanceof XSDParticle)
				{
					XSDParticleContent pcontent = ((XSDParticle)tdef).getContent();
					if(pcontent instanceof XSDModelGroup)
					{
						XSDModelGroup group = (XSDModelGroup)pcontent;
						EList tcontents = group.getContents();
					
						for(int i=0; i<tcontents.size(); i++)
						{
							XSDParticle obj = (XSDParticle)tcontents.get(i);						
							XSDTerm odecl = obj.getTerm();
							if(odecl instanceof XSDElementDeclaration)
							{
								XSDElementDeclaration edecl = (XSDElementDeclaration)odecl;
								if(edecl.getName().equals(typeName))
								  return edecl;
								
							}
							else if(odecl instanceof XSDModelGroup) //array attributes
							{
								EList elemList = ((XSDModelGroup)odecl).getContents();
								
								for(int k=0; k<elemList.size(); k++)
								{
									XSDTerm term = ((XSDParticle)elemList.get(k)).getTerm();
									if(term instanceof XSDElementDeclaration)
									{
										XSDElementDeclaration edecl = (XSDElementDeclaration)term;
										if(edecl.getName().equals(typeName))
										  return edecl;
								
									}
								}														
							}
							else if(odecl instanceof XSDWildcard)
							{
								XSDWildcard wcard = (XSDWildcard)odecl;
								if(wcard.getStringLexicalNamespaceConstraint().equals(typeName))
								  return wcard;
	
							}
							
						}
						
					}
					
				}	
			}		
			return null;
		}
	
	public Object getInheritedTypes(XSDTypeDefinition type)
	{
		if(inheritedTypesMap == null)
		  return null;
		  
		return inheritedTypesMap.get(type);  
	}
	
	public Object getTypeFromName(String name)
	{
		if(inheritedTypesMap == null)
		  return null;
		  
		Iterator iterator = inheritedTypesMap.keySet().iterator();
		while(iterator.hasNext())
		{
			XSDTypeDefinition type = (XSDTypeDefinition)iterator.next();
			if(type.getName().equals(name))
			   return type;
		}
		  
		return null;  
	}

	public static AcadEditorPlugin getDefault() {
		return INSTANCE;
	}

	public void logMessage(IStatus status, boolean showMessageDialog)
	{
		plugin.getLog().log(status);
    	
		if(showMessageDialog)
		{
			ErrorDialog.openError(getActiveWorkbenchWindow().getShell()
			   , "Generic Adaptor Message"
			   , null
			   , status
			   , IStatus.ERROR);    		
		}
    	
	}
    
	public void logMessage(IStatus status)
	{
		logMessage(status, false);
    	
	}
	
	public void log(Object logEntry)
	{
		if (logEntry instanceof Throwable)
		{
			Throwable err = (Throwable)logEntry;
			Status multiStatus = new Status(IStatus.ERROR, getPluginId(), 0
			      , err.getLocalizedMessage(), null);
			      			      
			logMessage(multiStatus, true);      
		}
		else
		{
			Status status = new Status(IStatus.ERROR, getPluginId(), 0
				  , logEntry.toString(), null);
				  
		    logMessage(status, true);		  
		}
		
	}

	public IWorkbenchWindow getActiveWorkbenchWindow() {
		return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	}
	
	/**
	 * 
	 * @return
	 */
	public IWorkbenchPage getActivePage() {
		IWorkbenchWindow window=getActiveWorkbenchWindow();
		if(window==null) {
			return null;
		}
		IWorkbenchPage page = getActiveWorkbenchWindow().getActivePage();

		if (page == null
			|| !page.getPerspective().getId().equals(
				AcadPerspective.ID_ACAD_PERSPECTIVE)) {
			final IWorkbenchWindow dwindow = getActiveWorkbenchWindow();
			page = null;

			try {

				IWorkbenchPage[] persps = dwindow.getPages();
				for (int idx = 0; idx < persps.length; idx++) {
					if (persps[idx]
						.getPerspective()
						.getId()
						.equals(AcadPerspective.ID_ACAD_PERSPECTIVE)) {
						page = persps[idx];

						dwindow.setActivePage(page);
						break;
					}
				}

				if (page == null) {
					IAdaptable element = ResourcesPlugin.getWorkspace().getRoot();
					IWorkbench workBench = dwindow.getWorkbench();
					if (workBench != null && element != null)
						page =
							workBench.showPerspective(
								AcadPerspective.ID_ACAD_PERSPECTIVE,
								getActiveWorkbenchWindow(),
								element);
				}
			} catch (Exception exc) {
//				AcadEditorPlugin.INSTANCE.log(exc);			
			}
		}

		return page;
	}

	public String getPluginId()
	{
		if(identifier == null)
		   identifier = plugin.getDescriptor().getUniqueIdentifier();
    	   
		return identifier;
	}

	public void createRequiredAttributes(RuleElementType element, XSDTypeDefinition type)
	{
		if(type instanceof XSDComplexTypeDefinition)
		{
			XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
			
			EList attrs = complexType.getAttributeUses();
			for(int idx=0; idx<attrs.size(); idx++)
			{
				XSDAttributeUse attr = (XSDAttributeUse) attrs.get(idx);
				
				if(!attr.isRequired())
				  continue;
				
				RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
				ruleAtribute.setName(attr.getAttributeDeclaration().getName());
				ruleAtribute.setIsRequiredByParent(false);
				
				element.getRuleAttribute().add(ruleAtribute);
				
				//add substitution rule
				SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
				subs.setMatch("^(.*)");
				subs.setSubstitute("replace with our message text");
				subs.setUseBuiltInFunction(true);
				subs.setUseBuiltInFunction(false);
				ruleAtribute.getSubstitutionRule().add(subs);
				
			}
		}		
	}
	
}
