/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleAttributeTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleElementTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RuleAttributeSection extends Composite
								implements IDetails, SelectionListener
										   , INotifyChangedListener, ModifyListener
{
	protected Label nameText;			
	protected Label uniqueId;
	protected Button usePreviuos;
	
	protected Label indexText;			
	protected Text defaultValue;
	protected Button requireByParentBtn;
    protected boolean isDisplaying;
    protected RuleAttributeType currentSelection;
    protected RuleAttributeTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory;
	
	
	public RuleAttributeSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new ParserItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
				
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME"), SWT.NONE);	
		nameText = factory.createLabel(this, "");
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "unspecified");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_INDEX"), SWT.NONE);	
		indexText = factory.createLabel(this, "");
		indexText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		usePreviuos = factory.createButton(this, AcadEditorPlugin.getDefault().getString("STR_USE_PREV_ATTR"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		usePreviuos.setLayoutData(data);	

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_DEFAULT_VALUE"), SWT.NONE);	
		defaultValue = factory.createText(this, "");
		defaultValue.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		defaultValue.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);	
		
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);			

		requireByParentBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_REQUIRE_BY_PARENT"), SWT.CHECK);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		requireByParentBtn.setLayoutData(data);		


		itemProvider = (RuleAttributeTypeItemProvider)itemFactory.createRuleAttributeTypeAdapter();
		itemProvider.addListener(this);
		
		usePreviuos.addSelectionListener(this);
		defaultValue.addModifyListener(this);
		requireByParentBtn.addSelectionListener(this);

	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
   
		if(currentSelection == object)
		  return;

		currentSelection = (RuleAttributeType)object;
		isDisplaying = true;
			
		nameText.setText(currentSelection.getName()==null?"":currentSelection.getName());
		uniqueId.setText(currentSelection.getId()==null?"unspecified":currentSelection.getId().toString());
		indexText.setText(currentSelection.getIndex()==null?"":currentSelection.getIndex());
		defaultValue.setText(currentSelection.getDefaultValue()==null?"":currentSelection.getDefaultValue());
		usePreviuos.setSelection(currentSelection.isUsePreviousMatchSubstitutionAsDefault());
		requireByParentBtn.setSelection(currentSelection.isIsRequiredByParent());

		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {
		
		this.currentSelection = (RuleAttributeType)currentSelection;    
		
	    this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(usePreviuos.getSelection());
		
	    this.currentSelection.setDefaultValue(defaultValue.getText());

		this.currentSelection.setIsRequiredByParent(requireByParentBtn.getSelection());		

	    return false;

	}
	
	public void setFocusToText(){
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == requireByParentBtn)
		{
			boolean value = requireByParentBtn.getSelection();
			if(value  != currentSelection.isIsRequiredByParent())
			{
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						RuleAttributeTypeItemProvider.REQUIRED_BY_PARENT);
				
				currentSelection.setIsRequiredByParent(value);
				
				Boolean oldValue = Boolean.valueOf(currentSelection.isIsRequiredByParent());		
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, oldValue);	
					
				
			}
		}
		else if(e.getSource() == usePreviuos) {
			IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection,
					RuleAttributeTypeItemProvider.USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT);
			
			currentSelection.setUsePreviousMatchSubstitutionAsDefault(usePreviuos.getSelection());		
			Boolean oldValue = Boolean.valueOf(currentSelection.isSetUsePreviousMatchSubstitutionAsDefault());		
			if(descriptor != null)
			{
				descriptor.setPropertyValue(currentSelection, oldValue);										
			}
		}
	}
	
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}	
	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == defaultValue)
		{
			String text = defaultValue.getText();
			if(!text.equals(currentSelection.getDefaultValue()))
			{
				if(text.length() == 0 && currentSelection.getDefaultValue() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						RuleAttributeTypeItemProvider.DEFAULT_VALUE);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
	}
}
