/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCProcess;


/**
 * @author slavescu
 *
 */
public class XMLtraceStartLoader extends TraceXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String traceId;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("traceId")) {
            traceId = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void addYourselfInContext() {
        //        zeroTime = time;
		if(context.getAgent()!=null)
		{
			context.getAgent().setStartTime(time);
			if(context.getAgent().getAgentProxy()!=null)
				context.getAgent().getAgentProxy().setStartTime(time);
		}

        TRCProcess p = getProcess();

        if (p.getStartTime() == 0) {
            p.setStartTime(createDeltaTime());
        }
        p.setId(traceId);

        // cleanup the call stack for previous trace (if exists)
        LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        traceId = null;
    }
}
