/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRCLL Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryUnits <em>Summary Units</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryNonzero <em>Summary Nonzero</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLLData#getTypeId <em>Type Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLLData#getHeadings <em>Headings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLLData#getMethod <em>Method</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData()
 * @model abstract="true"
 * @generated
 */
public interface TRCLLData extends EObject{
	/**
	 * Returns the value of the '<em><b>Summary Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Summary Units</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Summary Units</em>' attribute.
	 * @see #setSummaryUnits(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData_SummaryUnits()
	 * @model 
	 * @generated
	 */
	int getSummaryUnits();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryUnits <em>Summary Units</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Summary Units</em>' attribute.
	 * @see #getSummaryUnits()
	 * @generated
	 */
	void setSummaryUnits(int value);

	/**
	 * Returns the value of the '<em><b>Summary Nonzero</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Summary Nonzero</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Summary Nonzero</em>' attribute.
	 * @see #setSummaryNonzero(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData_SummaryNonzero()
	 * @model 
	 * @generated
	 */
	int getSummaryNonzero();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLLData#getSummaryNonzero <em>Summary Nonzero</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Summary Nonzero</em>' attribute.
	 * @see #getSummaryNonzero()
	 * @generated
	 */
	void setSummaryNonzero(int value);

	/**
	 * Returns the value of the '<em><b>Type Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type Id</em>' attribute.
	 * @see #setTypeId(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData_TypeId()
	 * @model 
	 * @generated
	 */
	String getTypeId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLLData#getTypeId <em>Type Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type Id</em>' attribute.
	 * @see #getTypeId()
	 * @generated
	 */
	void setTypeId(String value);

	/**
	 * Returns the value of the '<em><b>Headings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Headings</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Headings</em>' attribute.
	 * @see #setHeadings(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData_Headings()
	 * @model 
	 * @generated
	 */
	String getHeadings();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLLData#getHeadings <em>Headings</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Headings</em>' attribute.
	 * @see #getHeadings()
	 * @generated
	 */
	void setHeadings(String value);

	/**
	 * Returns the value of the '<em><b>Method</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethodWithLLData#getLLData <em>LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Method</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Method</em>' container reference.
	 * @see #setMethod(TRCMethodWithLLData)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLLData_Method()
	 * @see org.eclipse.hyades.models.trace.TRCMethodWithLLData#getLLData
	 * @model opposite="LLData" required="true"
	 * @generated
	 */
	TRCMethodWithLLData getMethod();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLLData#getMethod <em>Method</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Method</em>' container reference.
	 * @see #getMethod()
	 * @generated
	 */
	void setMethod(TRCMethodWithLLData value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns the number of LLUnits for which detailed information is available. If this returns zero, only the summary information is available.
	 * 
	 * <!-- end-model-doc -->
	 * @model parameters=""
	 * @generated
	 */
	int getUnitCount();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns an LLUnitData object with detailed information about the indicated unit_number. If instance is not null, then that instance is re-used (overwriting its fields with new data) and returned. Reusing the object instance saves construction time and heap traffic. See below for restrictions on re-using an LLUnitData instance. Unit numbers range from zero to GetUnitCount()-1.
	 * 
	 * <!-- end-model-doc -->
	 * @model dataType="org.eclipse.hyades.models.trace.LLUnitData" parameters="org.eclipse.emf.ecore.EInt org.eclipse.hyades.models.trace.LLUnitData"
	 * @generated
	 */
	LLUnitData getUnitData(int unitNumber, LLUnitData instance);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns true if count information is filled in, i.e. countArray is not null
	 * <!-- end-model-doc -->
	 * @model 
	 * @generated
	 */
	boolean hasCountInfo();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model 
	 * @generated
	 */
	boolean hasAccumulatedTimeInfo();

} // TRCLLData
