/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A method invocation is the entry and exit of the actual method implementation.
 * 
 * The base class does not track any attributes, for minimum overhead.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getMethod <em>Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy <em>Invoked By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokes <em>Invokes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getThread <em>Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getOwningObject <em>Owning Object</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation()
 * @model 
 * @generated
 */
public interface TRCMethodInvocation extends EObject{
	/**
	 * Returns the value of the '<em><b>Owning Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owning Object</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owning Object</em>' reference.
	 * @see #setOwningObject(TRCTraceObject)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_OwningObject()
	 * @model 
	 * @generated
	 */
	TRCTraceObject getOwningObject();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getOwningObject <em>Owning Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owning Object</em>' reference.
	 * @see #getOwningObject()
	 * @generated
	 */
	void setOwningObject(TRCTraceObject value);

	/**
	 * Returns the value of the '<em><b>Method</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethod#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Method</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Method</em>' reference.
	 * @see #setMethod(TRCMethod)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_Method()
	 * @see org.eclipse.hyades.models.trace.TRCMethod#getInvocations
	 * @model opposite="invocations" required="true"
	 * @generated
	 */
	TRCMethod getMethod();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getMethod <em>Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Method</em>' reference.
	 * @see #getMethod()
	 * @generated
	 */
	void setMethod(TRCMethod value);

	/**
	 * Returns the value of the '<em><b>Invoked By</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokes <em>Invokes</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invoked By</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Invoked By</em>' reference.
	 * @see #setInvokedBy(TRCMethodInvocation)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_InvokedBy()
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokes
	 * @model opposite="invokes"
	 * @generated
	 */
	TRCMethodInvocation getInvokedBy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy <em>Invoked By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Invoked By</em>' reference.
	 * @see #getInvokedBy()
	 * @generated
	 */
	void setInvokedBy(TRCMethodInvocation value);

	/**
	 * Returns the value of the '<em><b>Invokes</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy <em>Invoked By</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invokes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Invokes</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_Invokes()
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getInvokedBy
	 * @model type="org.eclipse.hyades.models.trace.TRCMethodInvocation" opposite="invokedBy"
	 * @generated
	 */
	EList getInvokes();

	/**
	 * Returns the value of the '<em><b>Thread</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Thread</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Thread</em>' reference.
	 * @see #setThread(TRCThread)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_Thread()
	 * @model required="true"
	 * @generated
	 */
	TRCThread getThread();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getThread <em>Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Thread</em>' reference.
	 * @see #getThread()
	 * @generated
	 */
	void setThread(TRCThread value);

	/**
	 * Returns the value of the '<em><b>Process</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCProcess#getInvocations <em>Invocations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' container reference.
	 * @see #setProcess(TRCProcess)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCMethodInvocation_Process()
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getInvocations
	 * @model opposite="invocations" required="true"
	 * @generated
	 */
	TRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess <em>Process</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' container reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(TRCProcess value);

} // TRCMethodInvocation
