/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TracePackage;

import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Line Coverage Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getLineTable <em>Line Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getHitTable <em>Hit Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getCountTable <em>Count Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getSourceInfo <em>Source Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCLineCoverageDataImpl extends TRCLLDataImpl implements TRCLineCoverageData {
	/**
	 * The default value of the '{@link #getLineTable() <em>Line Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineTable()
	 * @generated
	 * @ordered
	 */
	protected static final int[] LINE_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineTable() <em>Line Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineTable()
	 * @generated
	 * @ordered
	 */
	protected int[] lineTable = LINE_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getHitTable() <em>Hit Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHitTable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean[] HIT_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHitTable() <em>Hit Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHitTable()
	 * @generated
	 * @ordered
	 */
	protected boolean[] hitTable = HIT_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountTable() <em>Count Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountTable()
	 * @generated
	 * @ordered
	 */
	protected static final int[] COUNT_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountTable() <em>Count Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountTable()
	 * @generated
	 * @ordered
	 */
	protected int[] countTable = COUNT_TABLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSourceInfo() <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfo()
	 * @generated
	 * @ordered
	 */
	protected TRCSourceInfoWithLLData sourceInfo = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCLineCoverageDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCLineCoverageData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int[] getLineTable() {
		return lineTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineTable(int[] newLineTable) {
		int[] oldLineTable = lineTable;
		lineTable = newLineTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE, oldLineTable, lineTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean[] getHitTable() {
		return hitTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHitTable(boolean[] newHitTable) {
		boolean[] oldHitTable = hitTable;
		hitTable = newHitTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE, oldHitTable, hitTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int[] getCountTable() {
		return countTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCountTable(int[] newCountTable) {
		int[] oldCountTable = countTable;
		countTable = newCountTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE, oldCountTable, countTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData getSourceInfo() {
		if (sourceInfo != null && sourceInfo.eIsProxy()) {
			TRCSourceInfoWithLLData oldSourceInfo = sourceInfo;
			sourceInfo = (TRCSourceInfoWithLLData)eResolveProxy((InternalEObject)sourceInfo);
			if (sourceInfo != oldSourceInfo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO, oldSourceInfo, sourceInfo));
			}
		}
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData basicGetSourceInfo() {
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceInfo(TRCSourceInfoWithLLData newSourceInfo) {
		TRCSourceInfoWithLLData oldSourceInfo = sourceInfo;
		sourceInfo = newSourceInfo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO, oldSourceInfo, sourceInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getUnitCount() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LLUnitData getUnitData(int unitNumber, LLUnitData instance) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean hasCountInfo() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean hasAccumulatedTimeInfo() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_LINE_COVERAGE_DATA__METHOD, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
					return eBasicSetContainer(null, TracePackage.TRC_LINE_COVERAGE_DATA__METHOD, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA, TRCMethodWithLLData.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS:
				return new Integer(getSummaryUnits());
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO:
				return new Integer(getSummaryNonzero());
			case TracePackage.TRC_LINE_COVERAGE_DATA__TYPE_ID:
				return getTypeId();
			case TracePackage.TRC_LINE_COVERAGE_DATA__HEADINGS:
				return getHeadings();
			case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
				return getMethod();
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				return getLineTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				return getHitTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				return getCountTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS:
				setSummaryUnits(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO:
				setSummaryNonzero(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__TYPE_ID:
				setTypeId((String)newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HEADINGS:
				setHeadings((String)newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
				setMethod((TRCMethodWithLLData)newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				setLineTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				setHitTable((boolean[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				setCountTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS:
				setSummaryUnits(SUMMARY_UNITS_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO:
				setSummaryNonzero(SUMMARY_NONZERO_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__TYPE_ID:
				setTypeId(TYPE_ID_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HEADINGS:
				setHeadings(HEADINGS_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
				setMethod((TRCMethodWithLLData)null);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				setLineTable(LINE_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				setHitTable(HIT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				setCountTable(COUNT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_UNITS:
				return summaryUnits != SUMMARY_UNITS_EDEFAULT;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SUMMARY_NONZERO:
				return summaryNonzero != SUMMARY_NONZERO_EDEFAULT;
			case TracePackage.TRC_LINE_COVERAGE_DATA__TYPE_ID:
				return TYPE_ID_EDEFAULT == null ? typeId != null : !TYPE_ID_EDEFAULT.equals(typeId);
			case TracePackage.TRC_LINE_COVERAGE_DATA__HEADINGS:
				return HEADINGS_EDEFAULT == null ? headings != null : !HEADINGS_EDEFAULT.equals(headings);
			case TracePackage.TRC_LINE_COVERAGE_DATA__METHOD:
				return getMethod() != null;
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				return LINE_TABLE_EDEFAULT == null ? lineTable != null : !LINE_TABLE_EDEFAULT.equals(lineTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				return HIT_TABLE_EDEFAULT == null ? hitTable != null : !HIT_TABLE_EDEFAULT.equals(hitTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				return COUNT_TABLE_EDEFAULT == null ? countTable != null : !COUNT_TABLE_EDEFAULT.equals(countTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				return sourceInfo != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (lineTable: ");
		result.append(lineTable);
		result.append(", hitTable: ");
		result.append(hitTable);
		result.append(", countTable: ");
		result.append(countTable);
		result.append(')');
		return result.toString();
	}

} //TRCLineCoverageDataImpl
