/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;

import java.util.Map.Entry;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getStringValue <em>String Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getTRCInputOutputEntry <em>TRC Input Output Entry</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getContainer <em>Container</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectValueImpl extends EObjectImpl implements TRCObjectValue {
	/**
	 * The default value of the '{@link #getStringValue() <em>String Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStringValue()
	 * @generated
	 * @ordered
	 */
	protected static final String STRING_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStringValue() <em>String Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStringValue()
	 * @generated
	 * @ordered
	 */
	protected String stringValue = STRING_VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContainer() <em>Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainer()
	 * @generated
	 * @ordered
	 */
	protected TRCInputOutputContainer container = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectValueImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCObjectValue();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getStringValue() {
		return stringValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStringValue(String newStringValue) {
		String oldStringValue = stringValue;
		stringValue = newStringValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__STRING_VALUE, oldStringValue, stringValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entry getTRCInputOutputEntry() {
		if (eContainerFeatureID != TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY) return null;
		return (Entry)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTRCInputOutputEntry(Entry newTRCInputOutputEntry) {
		if (newTRCInputOutputEntry != eContainer || (eContainerFeatureID != TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY && newTRCInputOutputEntry != null)) {
			if (EcoreUtil.isAncestor(this, (EObject)newTRCInputOutputEntry))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTRCInputOutputEntry != null)
				msgs = ((InternalEObject)newTRCInputOutputEntry).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_ENTRY__VALUE, Map.Entry.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTRCInputOutputEntry, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, newTRCInputOutputEntry, newTRCInputOutputEntry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer getContainer() {
		if (container != null && container.eIsProxy()) {
			TRCInputOutputContainer oldContainer = container;
			container = (TRCInputOutputContainer)eResolveProxy((InternalEObject)container);
			if (container != oldContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_OBJECT_VALUE__CONTAINER, oldContainer, container));
			}
		}
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer basicGetContainer() {
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContainer(TRCInputOutputContainer newContainer, NotificationChain msgs) {
		TRCInputOutputContainer oldContainer = container;
		container = newContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__CONTAINER, oldContainer, newContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContainer(TRCInputOutputContainer newContainer) {
		if (newContainer != container) {
			NotificationChain msgs = null;
			if (container != null)
				msgs = ((InternalEObject)container).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
			if (newContainer != null)
				msgs = ((InternalEObject)newContainer).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
			msgs = basicSetContainer(newContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__CONTAINER, newContainer, newContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
				case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
					if (container != null)
						msgs = ((InternalEObject)container).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
					return basicSetContainer((TRCInputOutputContainer)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					return eBasicSetContainer(null, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
				case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
					return basicSetContainer(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_ENTRY__VALUE, Map.Entry.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				return getStringValue();
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry();
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				if (resolve) return getContainer();
				return basicGetContainer();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				setStringValue((String)newValue);
				return;
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Entry)newValue);
				return;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				setStringValue(STRING_VALUE_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Entry)null);
				return;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				return STRING_VALUE_EDEFAULT == null ? stringValue != null : !STRING_VALUE_EDEFAULT.equals(stringValue);
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry() != null;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				return container != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (stringValue: ");
		result.append(stringValue);
		result.append(')');
		return result.toString();
	}

} //TRCObjectValueImpl
