package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The ConnectSituation deals with the situations that identify aspects about a 
 * connection to another component. Messages that say a connection failed, that 
 * a connection was created, or that a connection was ended all fall into this 
 * category. Existing messages include words like connection reset, connection 
 * failed, and failed to get a connection, for example:
 * 
 * <code>
 * DBMN0015W: Failure while creating connection {0}
 * DBMN0033W: connection close failure {0}
 * DBMN0023W: Failed to close a connection {0}
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IConnectSituation extends ISituationType {
	
	/**
	  * Returns the successDisposition.
	  * 
	  * This property specifies the success disposition of an operation of a 
	  * situation that caused the situation to be reported.  The successDisposition 
	  * is a string with the following set of values:
	  * 
	  * SUCCESSFUL
	  * UNSUCESSFUL
	  * 
	  * This is a REQUIRED property and once it is set it MUST NOT change. 
	  * The string length for this property MUST NOT exceed 64 characters.
	  * 
	  * @return String The returned successDisposition.
	  * @since 1.0.1
	  */
	 public String getSuccessDisposition();

	 /**
	  * Returns the situationDisposition.
	  * 
	  * This property specifies the situation disposition that is representation 
	  * of the parameters necessary to describe the situation.  The situationDisposition 
	  * is a string with the following set of values:
	  * 
	  * INUSE
	  * FREED
	  * CLOSED
	  * AVAILABLE
	  * 
	  * This is a REQUIRED property and once it is set it MUST NOT change. 
	  * The string length for this property MUST NOT exceed 64 characters.
	  * 
	  * @return String The returned situationDisposition.
	  * @since 1.0.1
	  */
	 public String getSituationDisposition();

	 /**
	  * Sets the successDisposition.
	  * 
	  * This property specifies the success disposition of an operation of a 
	  * situation that caused the situation to be reported.  The successDisposition 
	  * is a string with the following set of values:
	  * 
	  * SUCCESSFUL
	  * UNSUCESSFUL
	  * 
	  * This is a REQUIRED property and once it is set it MUST NOT change. 
	  * The string length for this property MUST NOT exceed 64 characters.
	  * 
	  * @param successDisposition The successDisposition to be set.
	  * @since 1.0.1
	  */
	 public void setSuccessDisposition(String successDisposition);

	 /**
	  * Sets the situationDisposition.
	  * 
	  * This property specifies the situation disposition that is representation 
	  * of the parameters necessary to describe the situation.  The situationDisposition 
	  * is a string with the following set of values:
	  * 
	  * INUSE
	  * FREED
	  * CLOSED
	  * AVAILABLE
	  * 
	  * This is a REQUIRED property and once it is set it MUST NOT change. 
	  * The string length for this property MUST NOT exceed 64 characters.
	  * 
	  * @param situationDisposition The situationDisposition to be set.
	  * @since 1.0.1
	  */
	 public void setSituationDisposition(String situationDisposition);
}
