package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The DestroySituation deals with the situations documenting when an entity or 
 * component was removed or destroyed. Messages telling that a document was destroyed 
 * or a file was deleted all fall into this category. Existing message include words 
 * like was created, about to create, and now exists, for example:
 * 
 * <code>
 * CONM6007I: The connection pool was destroyed for data source (UDDI.Datasource.techs8.server1)
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IDestroySituation extends ISituationType {

    /**
     * Returns the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned successDisposition.
     * @since 1.0.1
     */
    public String getSuccessDisposition();

    /**
     * Sets the successDisposition.
     * 
     * This property specifies the success disposition of an operation of a 
     * situation that caused the situation to be reported.  The successDisposition 
     * is a string with the following set of values:
     * 
     * SUCCESSFUL
     * UNSUCESSFUL
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param successDisposition The successDisposition to be set.
     * @since 1.0.1
     */
    public void setSuccessDisposition(String successDisposition);
}