/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * @author sveyrier
 *
 */
public class MoveToMessage extends Action{
	
	private SDView view = null;
	
	public MoveToMessage(SDView theView)
	{
		super();
		view = theView;
	}
	
	public void run()
	{
/*		if ((view==null)||(view.getSDWidget())==null)
			return;
		else node = view.getSDWidget().getMouseOverNode();	*/
		
		SDWidget sdWidget = view.getSDWidget();
		if (sdWidget==null)
			return;
		ISelectionProvider selProvider = sdWidget.getSelectionProvider();
		ISelection sel=selProvider.getSelection();
		Object selectedNode= null;
		Iterator  it = ((StructuredSelection)sel).iterator();
		while (it.hasNext())
		{
			Object node = it.next();
			if (node instanceof BaseMessage)
				selectedNode = node;
		}	
		if (selectedNode==null)
			return;
			
		if (selectedNode instanceof SyncMessageReturn)
		{
			GraphNode node=((SyncMessageReturn)selectedNode).getMessage();
			sdWidget.clearSelection();
			sdWidget.addSelection(node);
			sdWidget.ensureVisible(node);
//			sdWidget.setFocusNode(node);
			sdWidget.redraw();
		}
		else if (selectedNode instanceof SyncMessage)
		{ 
			GraphNode node=((SyncMessage)selectedNode).getMessageReturn();
			sdWidget.clearSelection();
			sdWidget.addSelection(node);
			sdWidget.ensureVisible(node);
//			sdWidget.setFocusNode(node);
			sdWidget.redraw();
		}
		
				
	}
}
