/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.load;

import org.eclipse.hyades.uml2sd.ui.view.SDView;

/**
 * The interface all UML2SD loaders must implement
 */
public interface IUml2SDLoader {

	/**
	 * Set the viewer object to the loader that has been reloaded at the beginning
	 * of a new workbench session
	 */
	public void setViewer(SDView viewer);
	
	/**
	 * Title string for the UML2SD View when this loader is the one
	 * @return the string convenient for this loader
	 */
	public String getTitleString();
	
	/**
	 * When another loader becomes the one the previous one is replaced
	 * It's time clean-up if needed (listeners to be removed for example)
	 * @return the string convenient for this loader
	 */
	public void aboutToBeReplaced();
	
}
