/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.load;

import java.util.HashMap;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;


/**
 * Only one loader provides the UML2 Sequence Diagram widget with a frame at one moment.
 * This class ensures this.
 */
public class LoadersManager {

	private static LoadersManager loadersManager;
	
	private static HashMap map;
	
	private static SDView currentView;
	
	private String primaryViewId=null;

	
	/**
	 * Unaccessible default constructor
	 */
	private LoadersManager() {
		map = new HashMap();
	}
	
	/**
	 * A static method to get the manager instance
	 * @return the manager instance
	 */
	public static LoadersManager getLoadersManager() {
		if (loadersManager == null) {
			loadersManager = new LoadersManager();
		}
		return loadersManager;
	}
	
	/**
	 * Creates a loader instance
	 * @param className the name of the class to create an instance from
	 * @param cl the class loader convenient for this class (same plugin class loader)
	 * @param view the UML2 Sequence Diagram view instance
	 */
	public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) 
	{
		IUml2SDLoader loader = null;
		if (cl == null) {
			cl = getClass().getClassLoader();
		}
		try {
			Class clazz = cl.loadClass(className);
			loader = (IUml2SDLoader)clazz.newInstance();
		} catch(ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}
		//Make it current
		if (view!=null)
			setCurrentLoader(loader,view.getViewSite().getId());
		
		//Assign a view instance to this loader
		if (loader != null) {
			loader.setViewer(view);
		}
		return loader;
	}
	
	/**
	 * Changes the current unique loader the given Seconfay viewId.
	 * Use null to reference the primary SD View
	 * @param loader the current loader
	 * @param id the view secondary id or null
	 */
	public void setCurrentLoader(IUml2SDLoader loader, String id) 
	{
		if (id==null)
			return;
		
		//Get the loader in use
		IUml2SDLoader currentLoader=null;
		if (map.get(id) instanceof IUml2SDLoader)
			currentLoader = (IUml2SDLoader)map.get(id);
		
		if ((currentLoader != null)&&(currentLoader!=loader))
		{
			if (loader != null) 
			{
				IWorkbenchPage persp =UIPlugin.getActivePage();
				try
				{
					//Search the view corresponfing to the viewId
					SDView sdview=null;
					IViewReference viewref = (IViewReference) persp.findViewReference(id); //$NON-NLS-1$
					if (viewref!=null)
						sdview=(SDView)viewref.getView(false);
					
					//Make everthing clean for the new loader
					if (sdview != null) 
						sdview.resetProviders();
				}
				catch (Exception e){
					e.printStackTrace();
				}
			}
			//The old loader is going to be kicked
			currentLoader.aboutToBeReplaced();
		}
		IWorkbenchPage persp =UIPlugin.getActivePage();
		
		//Replace the current loader by the new one in the map
		map.put(id,loader);
		//Store this loader in the preferences to be able to restore it when the worbench will be relaunched
		if ((loader != null)&&(id!=null))
			SDViewerPlugin.getDefault().setLastLoader(loader.getClass().getName(),id);
	}

	/**
	 * Get the instance of the loader that is currently the one
	 */
/*	public IUml2SDLoader getCurrentLoader()
	{
		if (map.size()==0){
			SDViewerPlugin.getDefault().createLastLoaderIfAny();
		}
	 
		if (map.get(defaultViewId) instanceof IUml2SDLoader)
			return (IUml2SDLoader)map.get(defaultViewId);
		else return null;
	}*/
	
	public void resetLoaders(String viewId)
	{
		map.put(viewId,null);
	}
	
	/**
	 * Return the loader in use in the Sequence Diagram View 
	 * @param viewId the Sequence Diagram secondary Id. 
	 * Use null to reference the primary SD View
	 * @return the current loader if any - null otherwise
	 */
	public IUml2SDLoader getCurrentLoader(String viewId) 
	{
		if (viewId==null)
			return null;
		
		IWorkbenchPage persp =UIPlugin.getActivePage();
		try 
		{
			//Search the view corresponding to the viewId
			SDView view=null;
			IViewReference viewref = (IViewReference) persp.findViewReference(viewId); //$NON-NLS-1$
			if (viewref!=null)
				view=(SDView)viewref.getView(false);

			if (map.size()==0){
				SDViewerPlugin.getDefault().createLastLoaderIfAny();
			}
			
			//Return the loader corresponding to that view (if any)
		    if ((view!=null)&&(map.get(viewId) instanceof IUml2SDLoader))
				return (IUml2SDLoader)map.get(viewId);
			else return null;
		}
	    catch (Exception e)
		{
			return null;
		}
	}

}
