/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.help.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class DirectiveDetails extends Composite implements IDetails, Listener, FocusListener {

	private CCombo cmbDirective;
	private Text txtInfo;
	private Text txtFFDC;
	private Widget wLastSelected;	
	private ArrayList directiveRegistry = null;
	private SymptomDBEditor editor;
	private SDBFactoryImpl objFactory = null;
	private SDBDirective currentSel = null;
	private boolean isDisplaying = false;
	private final String NL = System.getProperties().getProperty("line.separator");
	/**
	 * Constructor for DirectiveDetails.
	 * @param parent
	 * @param style
	 */
	public DirectiveDetails(
		RASWidgetFactory factory,
		Composite composite,
		int style) {
		super(composite, style);
		GridLayout solLayout = new GridLayout();
		solLayout.numColumns = 1;

		this.setLayout(solLayout);
		this.setLayoutData(GridUtil.createFill());

		Label lblDirective =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_DIRECTIVE_LABEL"),
				SWT.NONE);
		cmbDirective = factory.createCombo(this, SWT.READ_ONLY);
		GridData cmbGrid = new GridData(GridData.FILL_HORIZONTAL);
		cmbGrid.widthHint = 350;
		cmbDirective.setLayoutData(cmbGrid);

		factory.createCompositeSeparator(this);

		Label lblInfo =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_DIRECTIVE_DESC_LABEL"),
				SWT.NONE);
		GridData lblInfoGrid = new GridData(GridData.FILL_HORIZONTAL);
		lblInfo.setLayoutData(lblInfoGrid);

		txtInfo =
			factory.createText(
				this,
				"",
				RASWidgetFactory.BORDER_STYLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		GridData infoGrid = new GridData(GridData.FILL_BOTH);
		infoGrid.widthHint = 350;
		txtInfo.setLayoutData(infoGrid);

		Label lblFFDC =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_FFDC_LABEL"),
				SWT.NONE);

		lblInfoGrid = new GridData(GridData.FILL_HORIZONTAL);
		lblFFDC.setLayoutData(lblInfoGrid);

		txtFFDC = factory.createText(
				this,
				"",
				RASWidgetFactory.BORDER_STYLE | SWT.MULTI);
		infoGrid = new GridData(GridData.FILL_HORIZONTAL);
		infoGrid.widthHint = 350;
		txtFFDC.setLayoutData(infoGrid);

		WorkbenchHelp.setHelp(cmbDirective, ContextIds.SYMDB_EDITOR_DIRECTIVE);
		WorkbenchHelp.setHelp(txtInfo, ContextIds.SYMDB_EDITOR_DIRECTIVE_DESCRIPTION);
		WorkbenchHelp.setHelp(txtFFDC, ContextIds.SYMDB_EDITOR_DIRECTIVE_FFDC);

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		cmbDirective.addListener(SWT.Selection, this);
		txtInfo.addListener(SWT.Modify, this);
		txtFFDC.addListener(SWT.Modify, this);
		txtInfo.addFocusListener(this);
		txtFFDC.addFocusListener(this);
		
		wLastSelected = null;	
	}
	public void init(SymptomDBEditor editor) {
		this.editor = editor;
		objFactory = SDbPlugin.getDefault().getSDBFactory();
		EList directives = editor.getModel().getDirectives();
		cmbDirective.add(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
		for (int i = 0; i < directives.size(); i++) {
			cmbDirective.add(getFirstLineFrom(((SDBDirective) directives.get(i)).getDescription()));
		}

		directiveRegistry = new ArrayList();

		SDBDirective newDir = objFactory.createSDBDirective();
		newDir.setDescription(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
		newDir.setDirectiveString("");
		directiveRegistry.add(0, newDir);
		directiveRegistry.addAll(directives);
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
		isDisplaying = true;
		currentSel = (SDBDirective) object;
		String desc = currentSel.getDescription();
		
		txtInfo.setText(desc);
		cmbDirective.setText(getFirstLineFrom(desc));
		txtFFDC.setText(currentSel.getDirectiveString());

		if (directiveRegistry.indexOf(currentSel) > -1) {
			txtInfo.setText(desc);
			cmbDirective.setText(getFirstLineFrom(desc));
			cmbDirective.setEnabled(false);
			txtFFDC.setText(currentSel.getDirectiveString());
		} else {
			cmbDirective.setEnabled(true);
			cmbDirective.select(0);
		}
		isDisplaying = false;
		wLastSelected = null;		
	}
	
	public void focusGained(FocusEvent e)
	{
		wLastSelected = e.widget;	
	}
 
	public void focusLost(FocusEvent e)
	{
		
	}
	
	public void setFocusToTextBox() {
		setFocusToTextBox(0, txtInfo.getText().length());
	}
	
	public void setFocusToTextBox(int startIndex, int endIndex){
		int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();
		
		if (startIndex < txtInfo.getText().length())
		{
			txtInfo.setSelection(startIndex, endIndex);
			wLastSelected = txtInfo;
		}
		else
		{
			txtFFDC.setSelection(startIndex-txtInfo.getText().length()-nlLength, endIndex-txtInfo.getText().length()-nlLength);
			wLastSelected = txtFFDC;
		}
	}
	
	public int getCursorPosition()
	{
		int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();
		
		if (wLastSelected == txtInfo)
			return SymptomDBSearchDialog.getCursorPosForSelection(txtInfo);
		else if (wLastSelected == txtFFDC)
			return txtInfo.getText().length() + nlLength + SymptomDBSearchDialog.getCursorPosForSelection(txtFFDC);
		else if (wLastSelected == null)
			return -1;
		else
			return 0;
	}
	
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

		if (cmbDirective.getSelectionIndex() == 0) {
			currentSel = (SDBDirective) currentSelection;

			currentSel.setDescription(txtInfo.getText());
			currentSel.setDirectiveString(txtFFDC.getText());
			if (directiveRegistry.indexOf(currentSel) < 0) {
				updateDirectiveRegistry(currentSel, true);
			}

		} else {

			if (cmbDirective.isEnabled()) {

				SDBSolution parent = (SDBSolution) editor.detailsPage.getParentOfCurrentSel();
				SDBRuntime db = (SDBRuntime) editor.detailsPage.getTreeRoot();
				updateDirectiveRegistry(currentSel, false);				
				currentSel.setDescription(txtInfo.getText());
				currentSel.setDirectiveString(txtFFDC.getText());
				currentSel.getSolutions().add((SDBSolution) parent);
				updateDirectiveRegistry(currentSel, true);				
				removeNewDirective((SDBDirective) currentSelection, parent, db);

			} else {

				updateDirectiveRegistry(currentSel, false);
				currentSel = (SDBDirective) currentSelection;
				currentSel.setDescription(txtInfo.getText());
				currentSel.setDirectiveString(txtFFDC.getText());
				updateDirectiveRegistry(currentSel, true);

			}

		}
		return true;
	}
	/**
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
		Widget source = event.widget;

		if (source == cmbDirective || source == txtInfo || source == txtFFDC) {

			boolean status = false;
			if (source == cmbDirective) {

				int i = cmbDirective.getSelectionIndex();

				currentSel = (SDBDirective) directiveRegistry.get(i);
				
				if (i == 0)
				{
					txtInfo.setText(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_INIT")+ ((SDBRuntime)editor.detailsPage.getTreeRoot()).getDirectives().size());
					txtFFDC.setText("");		
				}
				else
				{
					txtInfo.setText(currentSel.getDescription());
					txtFFDC.setText(currentSel.getDirectiveString());					
				}
				
			}
			if(source == txtInfo && isDisplaying == false){
				status = editor.validateState(txtInfo, this, currentSel.getDescription());
			}
			if(source == txtFFDC && isDisplaying == false){
				status = editor.validateState(txtFFDC, this, currentSel.getDirectiveString());				
			}

			if (currentSel != null && isDisplaying == false && status == true) {
				editor.updateUIDirtyStatus(true);
				editor.updateModelDirtyStatus(true);
			}
		}
	}
	private void removeNewDirective(
		SDBDirective current,
		SDBSolution parent,
		SDBRuntime root) {

		parent.getDirectives().remove(current);
		root.getDirectives().remove(current);
		current.getSolutions().remove(parent);
		directiveRegistry.remove(current);
	}
	protected void updateDirectiveRegistry(SDBDirective object, boolean add) {
		if (add) {
			directiveRegistry.add(object);
			cmbDirective.add(getFirstLineFrom(object.getDescription()));
		} else {
			if(directiveRegistry.indexOf(object)>-1){
				cmbDirective.remove(directiveRegistry.indexOf(object));
				directiveRegistry.remove(object);
			}
			/*if(!object.getDescription().equals(RASPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL")))
				cmbDirective.remove(object.getDescription());*/

		}
	}
	/**
	 * returns first line from input string
	 */
	private String getFirstLineFrom(String input) {
		int i = 0;
		String line = input;
		if ((i = input.indexOf("\r\n")) > -1) {
			line = input.substring(0, i);
		} else if ((i = input.indexOf("\n")) > -1)
			line = input.substring(0, i);

		return TString.replaceTabsWithWhiteSpace(line);
	}
	/**
	 * takes out first line from input string
	 */
	private String getDirectiveStringFrom(String input) {
		int i = 0;
		String line = "";

		if ((i = input.indexOf("\r\n")) > -1) {
			line = input.substring(i + 2);
		} else {
			if ((i = input.indexOf("\n")) > -1) {
				line = input.substring(i + 1);
			}
		}
		return TString.replaceTabsWithWhiteSpace(line);
	}

	/*	private String convertToPlatformNL(String input){
			
			int i = 0;
			String output = input;
			String nl = "\r\n";
	
			if((i= input.indexOf("\r\n"))== -1){
		    	if((i= input.indexOf("\n")) > -1){
					nl = "\n";
		    	}
		    	else
		    		return input;
			}		
	
			if(nl!=NL){
	
		    	StringBuffer lines = new StringBuffer();
	
			    i = 0; 
			    int j = 0;
		
			    while(i<=input.length()){
		
					if((j= input.indexOf(nl, i)) > -1){
			    		lines.append(input.substring(i,j) + NL);
					}else{			
				    	 lines.append(input.substring(i));
				    	 break;
					}
					i=j + nl.length();
			    }
				output = lines.toString();
			}
	
	    	return output;			
	
		}*/
}
