/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.common.internal;

import java.io.IOException;

import org.eclipse.hyades.perfmon.utils.internal.*;

import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;

import org.eclipse.hyades.statistical.ui.variableloader.internal.*;
import org.eclipse.hyades.statistical.ui.editor.internal.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.swt.widgets.Display;

public class CommonModifierProxy implements SDVariableModifierProxy {

public static final double DEFAULT_FREQUENCY = 1.0;	//seconds
	
DCAgentCommandUtil command;
protected StatConInterface statcon;

protected SDVariableLoader varloader;

protected SDModifiableVariableRepresentation freq_var;
protected double frequency = 1.0;	//seconds

protected TRCAgent agent;

VariablePadder padder;

public static final String ID_PERFMON_FREQUENCY = "PERFMON#FREQUENCY";

	public SDModifiableVariableRepresentation getFrequencyVariable() {
		return freq_var;
	}

	protected CommonModifierProxy(StatConInterface statcon, TRCAgent agent) {
		this.statcon = statcon;
		this.agent = agent;
	}
	
	public CommonModifierProxy(DCAgentCommandUtil command, StatConInterface statcon, TRCAgent agent) {
		this.command = command;
		this.statcon = statcon;
		this.agent = agent;
		init();
	}
	
	protected void init() {	
		
		varloader = new SDVariableLoader(agent,PerfmonPlugin.getString("PERFMON_CONTROLS"));
		
		PerfmonPlugin.DBG.info("Creating frequency variable");
		freq_var = varloader.createSDModifiableVariable(
									ID_PERFMON_FREQUENCY,
									PerfmonPlugin.getString("FREQUENCY_SEC"),
									PerfmonPlugin.getString("FREQUENCY_DESCRIPTION"),
									null,
									false,
									SDMeasuredVariable.DOUBLE,
									SDModifiableVariable.DOUBLE,
									PerfmonPlugin.getString("FREQUENCY"),
									PerfmonPlugin.getString("PERFMON_CONTROLS"),
									this,
									0.5d,
									Double.MAX_VALUE
									);

		Display.getDefault().syncExec(new DisplayInit());
	}

	public void requestValue(String unique_id, int i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, long i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, float i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, double d) throws ClassCastException {
		if (unique_id.equals(ID_PERFMON_FREQUENCY)) {
			if (d < 0.5) d = 0.5;
			int i = (int)(d * 1000.0d);
			try {
				SetVariableCommand fcommand = new SetVariableCommand(SetVariableCommand.VAR_FREQUENCY,i);
				command.setVariable(fcommand);
//				loader.setFrequency(i);
				frequency = d;
				freq_var.setMeasuredValue(System.currentTimeMillis(),d);
			} catch (IOException e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_SETTING_FREQUENCY")+" "+i,false);
			}
		}
	}
	public void requestValue(String unique_id, Object newval) throws ClassCastException {
		requestValue(unique_id,((Number)newval).doubleValue());
	}
	
	public void shutdown() {
		padder.die = true;
	}

	class VariablePadder extends Thread {
		boolean die = false;
		public VariablePadder() {
			setDaemon(true);
		}
		public void run() {
			while (!die) {
				try {
					Thread.sleep(750);	
				} catch (Exception e) {
				}
				try {
					freq_var.padRequestedValue(System.currentTimeMillis());
					freq_var.setMeasuredValue(System.currentTimeMillis(),freq_var.getLastMeasuredValue());	
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - "+e);
				}
			}
		}
	}
	
	class DisplayInit implements Runnable {
		public void run() {
			try {
				PerfmonPlugin.DBG.info("Setting requested frequency to "+DEFAULT_FREQUENCY);
				freq_var.setRequestedValue(System.currentTimeMillis(),DEFAULT_FREQUENCY);

				padder = new VariablePadder();
				padder.start();	
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_STATCON_UPDATE")+" (3)",true);
			}
		}
	}
	
	
	
}