/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.common.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

import org.eclipse.swt.graphics.*;

import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentGenericLoader;
import org.eclipse.hyades.perfmon.utils.internal.StatConImageApplier;

import org.eclipse.hyades.internal.execution.local.control.*;

import org.eclipse.hyades.perfmon.utils.internal.*;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.model.statistical.*;
import org.eclipse.hyades.models.hierarchy.*;

import org.eclipse.core.runtime.*;

import org.eclipse.emf.common.util.*;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;

import java.io.*;
import java.text.*;
import java.util.*;

public class CommonModuleTrace implements Runnable, AgentChangeListener {

static int ID_POSTFIX = 0;
static Object ID_LOCK = new Object();

int TRCID;
	
ImageManager img = PerfmonPlugin.img;

protected StatConInterface statcon;

IProgressMonitor pmonitor;
	
String ACTION_STOP_TRACE = "ACTION_STOP_TRACE_ID";
String ACTION_UPDATE_TREE = "ACTION_UPDATE_TREE_ID";

String ACTION_START_TRACING = "ACTION_START_TRACING_ID";
String ACTION_STOP_TRACING = "ACTION_STOP_TRACING_ID";

ClickListener click_listener;

String tracename;

SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

boolean new_monitor = true;
protected TRCAgent agent;
DCAgentGenericLoader loader;

CommonModifierProxy cmodproxy;
AgentUpdater agentupdate;

URI smodelpath;
URI monitor_uri;

String rachost;

private Init init;

	public void unloadTrace() {
		try {
			cmodproxy.shutdown();
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to shut down Common Modifier Proxy");
		}

		try {
			agentupdate.shutdown();
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to shut down Agent updater");
		}
		
		try {
			loader.shutdown();
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
		}

		try {
			statcon.setConstantUpdate("PERFMON UPDATE "+loader.hashCode(),false,1000);
			statcon.setAgentImage(agent,img.getImage(ImageManager.IMG_PERFMON_STOP));
			
			statcon.removeDynamicAction(ACTION_STOP_TRACE+TRCID);
			statcon.removeDynamicAction(ACTION_UPDATE_TREE+TRCID);
			statcon.removeDynamicAction(ACTION_START_TRACING+TRCID);
			statcon.removeDynamicAction(ACTION_STOP_TRACING+TRCID);
				
			statcon.removeClickListener(click_listener);
//			statcon.removeAgentAction(agent,ACTION_STOP_TRACE);
//			statcon.removeAgentAction(agent,ACTION_UPDATE_TREE);
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
		}
		
		statcon.removeAgentChangeListener(this);
	}

	public void agentAdded(TRCAgent dead_agent) {
	}

	public void agentRemoved(TRCAgent dead_agent) {
		if (agent == dead_agent) {
			unloadTrace();	
		}
	}

	public CommonModuleTrace() {
		synchronized(ID_LOCK) {
			TRCID = ID_POSTFIX++;
		}
	}
	
	protected void init(		StatConInterface statcon, 
								String rac_host, 
								String process_exe,
								String trace_prefix,
								String trace_postfix,
								String agent_name,
								SetVariableCommand[] reg_commands, 
								URI smodelpath, 
								URI monitor_uri) {
		this.statcon = statcon;
		this.smodelpath = smodelpath;
		this.monitor_uri = monitor_uri;
		this.rachost = rac_host;

		init = new Init(rac_host,process_exe,trace_prefix,trace_postfix,agent_name,reg_commands);
	}
	
	public void setProgressMonitor(IProgressMonitor pmonitor) {
		this.pmonitor = pmonitor;
	}
	
	public void run() {
		init.run();
	}

	protected String getStatModelFileName() {
		return tracename;
	}
	
	private void removeRepresentations(SDDescriptor descriptor) {
		if (descriptor == null) return;
		if (descriptor instanceof SDMemberDescriptor) {
			SDMemberDescriptor mem = (SDMemberDescriptor)descriptor; 
			mem.setRepresentation(null);
			EList obslist = mem.getSnapshotObservation();
			for (int i = 0; i < obslist.size(); i++) {
				SDSnapshotObservation obs = (SDSnapshotObservation)obslist.get(i);
				if (obs.getWindow() == null) {
					PerfmonPlugin.DBG.warning("NULL OBSERVATION WINDOW UNDER "+descriptor.getName()+" ("+descriptor.getDescription()+")");	
				}	
			}	
		}
		EList list = descriptor.getChildren();
		for (int i = 0; i < list.size(); i++) {
			removeRepresentations((SDDescriptor)list.get(i));	
		}
	}

	private void configureSliders() throws Exception {
		TimeZoomSlider xslider = statcon.getGraphWindow().getXSlider(0);
		double minvis = xslider.getMinVisible();
		double maxvis = xslider.getMaxVisible();
		double min = xslider.getMinLimit();
		double max = xslider.getMaxLimit();
		
		double ctime = System.currentTimeMillis();
		
		minvis = ctime;
		maxvis = ctime + (1000 * 60);
		min = Math.min(min,ctime - (double)(1000 * 60 * 60));
		max = Math.max(max,ctime + (double)(1000 * 60 * 60 * 24));

		xslider.configure(min,max,minvis,maxvis,xslider.getResolution());		
		
		ZoomSlider yslider = statcon.getGraphWindow().getYSlider(0);
		minvis = yslider.getMinVisible();
		maxvis = Math.max(yslider.getMaxVisible(),100.0d);
		min = yslider.getMinLimit();
		max = Math.max(yslider.getMaxLimit(),maxvis*10);
		
		yslider.configure(min,max,minvis,maxvis,yslider.getResolution());			
	}

	private class ProfileUpdate implements Runnable {
		ProfileEvent event;
		
		public void run() {
			try {
				UIPlugin.getDefault().notifyProfileEventListener(event);
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_SEND_PROFILING"),true);
			}
		}
	}
	
	private class StatconUpdate implements Runnable {
		public void run() {
			try {

				statcon.setConstantUpdate("PERFMON UPDATE "+loader.hashCode(),true,1000);
	
				statcon.addAgent(agent);
//				statcon.addAgentAction(agent,ACTION_STOP_TRACE,PerfmonPlugin.getString("STOP_TRACE"),img.getImage(ImageManager.IMG_PERFMON_STOP),new StopTraceAction(loader,agent));
	
				statcon.addDynamicAction("perfmon.common.agent",ACTION_STOP_TRACE+TRCID,PerfmonPlugin.getString("STOP_TRACE"),new StopTraceDAction(loader,agent));
				statcon.addDynamicAction("perfmon.common.control",ACTION_UPDATE_TREE+TRCID,PerfmonPlugin.getString("UPDATE_TREE"),new UpdateTreeDAction(loader,agent));
				statcon.addDynamicAction("perfmon.common.control",ACTION_START_TRACING+TRCID,PerfmonPlugin.getString("START_TRACING"),new CounterON(loader,agent));
				statcon.addDynamicAction("perfmon.common.control",ACTION_STOP_TRACING+TRCID,PerfmonPlugin.getString("STOP_TRACING"),new CounterOFF(loader,agent));
				
//				statcon.addModelAction(agent,ACTION_UPDATE_TREE,PerfmonPlugin.getString("UPDATE_TREE"),img.getImage(ImageManager.IMG_PERFMON_UPDATE_TREE),new UpdateTreeAction(loader,agent));
//				statcon.addModelAction(agent,ACTION_START_TRACING,PerfmonPlugin.getString("START_TRACING"),img.getImage(ImageManager.IMG_PERFMON_START),new CounterON(loader));
//				statcon.addModelAction(agent,ACTION_STOP_TRACING,PerfmonPlugin.getString("STOP_TRACING"),img.getImage(ImageManager.IMG_PERFMON_STOP),new CounterOFF(loader));
	
				configureSliders();

				//set the agent URI
				statcon.setAgentFile(agent,agent.eResource().getURI());

				PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
				statcon.addAgentChangeListener(CommonModuleTrace.this);
					
				statcon.setAgentImage(agent,img.getImage(ImageManager.IMG_PERFMON_START));
				
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_STATCON_UPDATE")+" (2)",true);
			}
		}
	}
	
	private class Init extends Thread {
		String rac_host;
		String trace_prefix;
		String trace_postfix;
		String agent_name;
		SetVariableCommand[] reg_commands;
		String process_exe;
		public Init(String rac_host, String process_exe, String trace_prefix, String trace_postfix, String agent_name, SetVariableCommand[] reg_commands) {
			this.rac_host = rac_host;
			this.process_exe = process_exe;
			this.trace_prefix = trace_prefix;
			this.trace_postfix = trace_postfix;
			this.agent_name = agent_name;
			this.reg_commands = reg_commands;
		}

		public void run() {
//		private void init(String rac_host, String reg_host) {

			if (pmonitor != null) 
			    pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));

			try {
				HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
			
				long started = System.currentTimeMillis();

				String host = rac_host;
				int port = 10002;

				tracename = trace_prefix+" "+PerfmonPlugin.getString("TRACE")+" - "+trace_postfix+" "+smodel_sdf.format(new Date(started));
				String modelname = trace_prefix+" "+PerfmonPlugin.getString("HOST_TRACE")+" - "+smodel_sdf.format(new Date(started));

				agent = TRCAgentUtil.newAgent(smodelpath,monitor_uri,null,null,null,getStatModelFileName(),tracename,rachost,agent_name,tracename,"Profiler");

				//
				// Create the Variable Loader - abstracts the concept of variables in a statistical model
				//
				PerfmonPlugin.DBG.info("Creating variable loader");

				loader = new DCAgentGenericLoader(pmonitor,started,agent,modelname,process_exe,host,port,reg_commands,(int)(1000.0*CommonModifierProxy.DEFAULT_FREQUENCY));

 				if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));

				ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
				event.setSource(agent.getAgentProxy());
				event.setType(ProfileEvent.START_MONITOR);
				ProfileUpdate update = new ProfileUpdate();
				update.event = event;
				Display.getDefault().syncExec(update);

				//
				// Create the Common Modifier Proxy - manages changes to common variables like frequency
				// Create the Agent update thread - listens to the model and updates statcon as necessary
				//
				if (statcon != null) {
					PerfmonPlugin.DBG.info("Creating common variable modifier proxy");
					cmodproxy = new CommonModifierProxy(loader.getCommandUtil(),statcon,agent);
					PerfmonPlugin.DBG.info("Creating agent update thread");
					agentupdate = new AgentUpdater(statcon,agent,loader);

					Display.getDefault().syncExec(new StatconUpdate());
					
					click_listener = new CommonClickListener(loader, agent);
					statcon.addClickListener(click_listener);
				}
				Display.getDefault().asyncExec(new SliderFollow());

				//save the agent
				TRCAgentUtil.saveTRCAgent(agent);
				
				//progress monitor done
				if (pmonitor != null) pmonitor.done();

			} catch (AgentControllerUnavailableException t) {
				//progress monitor done
				if (pmonitor != null)
				    pmonitor.done();

				PerfmonPlugin.DBG.logVisibleError(t,PerfmonPlugin.getString("ERROR_NO_RAC"),true);

			} catch (Throwable t) {
				//progress monitor done
				if (pmonitor != null)
				    pmonitor.done();

				PerfmonPlugin.DBG.logVisibleError(t,PerfmonPlugin.getString("ERROR_STARTING_TRACE"),true);
			}
		}
	}
	
	private class SliderFollow implements Runnable {
		public void run() {
			if (statcon != null) {
				statcon.getGraphWindow().setTimeSliderFollowing(statcon.getGraphWindow().getXSlider(0),true);
			}
		}
	}

	private class StopTraceDAction extends DynamicAction {
		DCAgentGenericLoader loader;
		TRCAgent agent;
		public StopTraceDAction(DCAgentGenericLoader loader, TRCAgent agent) {
			this.loader = loader;
			this.agent = agent;
		}
		public Image getImage() {
			return img.getImage(ImageManager.IMG_PERFMON_STOP);
		}
		public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			if (relations.length == 1) {
				if (relations[0] == agent) {
					return true;
				}
			}
			return false;
		}
		public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			unloadTrace();
			
			try {
				EList descriptors = agent.getDescriptor();
				for (int i = 0; i < descriptors.size(); i++) {
					removeRepresentations((SDDescriptor)descriptors.get(i));	
				}

				TRCAgentUtil.saveTRCAgent(agent);
//				saveStatisticalModel();
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("problem saving statistical model",e);
			}
			try {
				loader.killProcess();
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("problem killing perfmon process",e);
			}
		}
	}
	
	private class UpdateTreeDAction extends DynamicAction {
		DCAgentGenericLoader loader;
		TRCAgent agent;
		public UpdateTreeDAction(DCAgentGenericLoader loader, TRCAgent agent) {
			this.loader = loader;
			this.agent = agent;
		}
		public Image getImage() {
			return img.getImage(ImageManager.IMG_PERFMON_UPDATE_TREE);
		}
		
		public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			boolean oneValid = false;
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] == null) {
//ignore null entries? shouldnt ever happen really			
//					return false;
				} else if (!(relations[i] instanceof SDDescriptor)) {
//System.out.println(i+" NOT A DESCRIPTOR - "+relations[i]);					
					return false;
				} else {
					SDDescriptor test = (SDDescriptor)relations[i];
					while (test.getAgent() == null) {
						//search for a TRCAgent reference
						test = test.getParent();
						if (test == null) {
//System.out.println(i+" NO TRCAGENT REF FOUND");					
							return false;
						}
					}
					if (test.getAgent() != agent) {
//System.out.println(i+" NOT MY AGENT "+agent+" / "+test.getAgent());
//System.out.println(i+" NOT MY AGENT "+agent.getName()+" / "+test.getAgent().getName());
						return false;
					} else {
						oneValid = true;
					}
				}
			}
			return oneValid;
		}
		public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] != null) {
					try {
//						SDDescriptor selected = statcon.getSelectedDescriptor();
						SDDescriptor selected = (SDDescriptor)relations[i];
						loader.getCommandUtil().getUpdatedTree(selected);
					} catch (IOException e) {
						PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_UPDATE_TREE"),false);	
					}
				}
			}
		}
	}

	private class CounterON extends DynamicAction {
		DCAgentGenericLoader loader;
		TRCAgent agent;
		public CounterON(DCAgentGenericLoader loader, TRCAgent agent) {
			this.loader = loader;	
			this.agent = agent;
		}
		public Image getImage() {
			return img.getImage(ImageManager.IMG_PERFMON_START);
		}
		public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			boolean oneValid = false;
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] == null) {
//ignore null entries? shouldnt ever happen really			
//					return false;
				} else if (!(relations[i] instanceof SDDescriptor)) {
					return false;
				} else {
					SDDescriptor test = (SDDescriptor)relations[i];
					while (test.getAgent() == null) {
						//search for a TRCAgent reference
						test = test.getParent();
						if (test == null) {
							return false;
						}
					}
					if (test.getAgent() != agent) {
						return false;
					} else {
						oneValid = true;
					}
				}
			}
			return oneValid;
		}
		public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] != null) {
					try {
						SDDescriptor selected = (SDDescriptor)relations[i];
						loader.getCommandUtil().startTracing(selected);

						try {
							StatConImageApplier.applyBoth(statcon,selected,StatConImageApplier.getStandardTracingImage());
						} catch (Exception e) {
							EditorPlugin.DBG.warning("start trace action failed to apply start tracing images",e);
						}

					} catch (Exception e) {
						PerfmonPlugin.DBG.error("unable to set counter to ON",e);	
					}
				}
			}
		}
	}
	
	private class CounterOFF extends DynamicAction {
		DCAgentGenericLoader loader;
		TRCAgent agent;
		public CounterOFF(DCAgentGenericLoader loader, TRCAgent agent) {
			this.loader = loader;	
			this.agent = agent;
		}
		public Image getImage() {
			return img.getImage(ImageManager.IMG_PERFMON_STOP);
		}
		public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			boolean oneValid = false;
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] == null) {
//ignore null entries? shouldnt ever happen really			
//					return false;
				} else if (!(relations[i] instanceof SDDescriptor)) {
					return false;
				} else {
					SDDescriptor test = (SDDescriptor)relations[i];
					while (test.getAgent() == null) {
						//search for a TRCAgent reference
						test = test.getParent();
						if (test == null) {
							return false;
						}
					}
					if (test.getAgent() != agent) {
						return false;
					} else {
						oneValid = true;
					}
				}
			}
			return oneValid;
		}
		public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
			for (int i = 0; i < relations.length; i++) {
				if (relations[i] != null) {
					try {
						SDDescriptor selected = (SDDescriptor)relations[i];
						loader.getCommandUtil().stopTracing(selected);

						try {
							StatConImageApplier.applyDown(statcon,selected,StatConImageApplier.getStandardStoppedImage());
						} catch (Exception e) {
							EditorPlugin.DBG.warning("stop trace action failed to apply stop tracing images",e);
						}
						//						apply(selected);
					} catch (Exception e) {
						PerfmonPlugin.DBG.error("unable to set counter to ON",e);	
					}
				}
			}
		}
	}
}