/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.jonas.internal;

import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConStatisticalImageProvider;

import org.eclipse.swt.graphics.Image;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.model.statistical.*;

public class JonasStatisticalImageProvider implements StatConStatisticalImageProvider {
	
	private boolean isOurs(TRCAgent agent) {
		//NOTE! MUST BE LOWER CASE MATCH
		return agent.getName().toLowerCase().startsWith(JonasConstants.AGENT_PREFIX.toLowerCase());
	}
	
	public Image getImage(SDDescriptor descriptor) {
		//we dont do anything here
		return null;
	}
	public Image getImage(SDDescriptor descriptor, TRCAgent agent) {
		if (isOurs(agent)) {
			if (descriptor.getId() != null) {
//this is handled by descriptor type now
//				if (descriptor.getId().indexOf('C') != -1) 
//				{	
//					return PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_COUNTER);
//				}
//				else 
				if (descriptor.getId().indexOf('M') != -1) 
				{	
					return PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_MBEAN);
				}
			}
		}
		return null;
	}
}