/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.linux.internal.launchconfig;

import org.eclipse.debug.core.*;
import org.eclipse.debug.ui.*;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;

import org.eclipse.ui.*;
import org.eclipse.ui.dialogs.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;

import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.*;

import org.eclipse.hyades.trace.ui.internal.util.*;

public class LinuxMainTab extends AbstractLaunchConfigurationTab implements ILaunchConfigurationTab, SelectionListener, KeyListener {
	
	//
	// TODO the initializeFrom method or setDefaults method might get called before the controls are initialized
	//
	//

ILaunchConfigurationDialog dialog;	
	
boolean isdirty = false;
String message = null;
String error_message = null;
	
Composite mainpanel;

Composite host_panel;
	Label rac_host_label;
	Text rac_host_text;

Composite container_panel;
	Label container_label;
	Text container_text;
	Button container_browse;

Composite monitor_panel;
	Label monitor_label;
	Text monitor_text;
	Button monitor_browse;


	public void setMessage(String msg) {
		message = msg;
		if (message.length() == 0) message = null;
		updateLaunchConfigurationDialog();
	}
	
	public void setError(String msg) {
		error_message = msg;
		if (error_message.length() == 0) error_message = null;
		updateLaunchConfigurationDialog();
	}
	
	public void setDirty(boolean b) {
		isdirty = b;
		checkForErrors();
		updateLaunchConfigurationDialog();
	}
	
	public void createControl(Composite parent) {
		GridLayout glayout = new GridLayout();
		glayout.numColumns = 1;

		mainpanel = new Composite(parent,0);
		mainpanel.setLayout(glayout);
		
		glayout = new GridLayout();
		glayout.numColumns = 1;

		host_panel = new Composite(mainpanel,0);
		host_panel.setLayout(glayout);
		host_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		rac_host_label = new Label(host_panel,SWT.LEFT);
		rac_host_label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		rac_host_text = new Text(host_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		rac_host_text.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		rac_host_label.setText(PerfmonPlugin.getString("RAC_HOST"));
		rac_host_text.setText("?");
		
		glayout = new GridLayout();
		glayout.numColumns = 2;
		
		container_panel = new Composite(mainpanel,0);
		container_panel.setLayout(glayout);
		container_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		container_label = new Label(container_panel,SWT.LEFT);
		container_label.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		container_text = new Text(container_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		container_text.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		container_browse = new Button(container_panel,0);
		container_browse.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.FILL));

		container_label.setText(PerfmonPlugin.getString("PROFILING_PROJECT"));
		container_text.setText("platform:/resource/"+PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT"));
//		container_text.setEditable(false);
		container_browse.setText(PerfmonPlugin.getString("BROWSE"));

		glayout = new GridLayout();
		glayout.numColumns = 2;
		
		monitor_panel = new Composite(mainpanel,0);
		monitor_panel.setLayout(glayout);
		monitor_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		monitor_label = new Label(container_panel,SWT.LEFT);
		monitor_label.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		monitor_text = new Text(container_panel,SWT.SINGLE|SWT.LEFT|SWT.BORDER);
		monitor_text.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		monitor_browse = new Button(container_panel,0);
		monitor_browse.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.FILL));

		monitor_label.setText(PerfmonPlugin.getString("PROFILING_MONITOR"));
		monitor_text.setText(PerfmonPlugin.getString("DEFAULT_MONITOR"));
//		monitor_text.setEditable(false);
		monitor_browse.setText(PerfmonPlugin.getString("BROWSE"));

		monitor_browse.addSelectionListener(this);
		container_browse.addSelectionListener(this);
		
		rac_host_text.addKeyListener(this);
		container_text.addKeyListener(this);
		monitor_text.addKeyListener(this);
		
		checkForErrors();
	}

	public void keyPressed(KeyEvent e) {
		setDirty(true);
	}
	public void keyReleased(KeyEvent e) {
		setDirty(true);
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	} 
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == monitor_browse) {
			MonitorSelectionDialog mdialog = new MonitorSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),PerfmonPlugin.getString("PROFILING_DIALOG"));

			if (mdialog.open() == MonitorSelectionDialog.OK)	{
				Object[] result = mdialog.getResult();
				if (result != null && result.length == 1 && result[0] != null)
				{
					IPath path = (IPath) result[0];
					URI monitor_uri = URI.createPlatformResourceURI(path.toString());
					monitor_text.setText(monitor_uri.toString().replaceFirst("platform:/resource/",""));
//					_monitor.setText(path.lastSegment());
//					_location.setText(path.uptoSegment(path.segmentCount()-1).toOSString());
//					_monitor.setFocus();	
					setDirty(true);
				}
			}

		} else if (e.getSource() == container_browse) {
			IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
			Path container_savepath = null;
			IContainer container = null;
			try {
				container_savepath = new Path(""+container_text.getText());
				container = workspaceRoot.getFolder(container_savepath);
			} catch (Throwable x) {
				PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path "+container_text.getText());
			}

			PerfmonPlugin.DBG.info("showing container selection dialog");
			//pop up a dialog	
			ContainerSelectionDialog dialog = null;
			dialog = new ContainerSelectionDialog(mainpanel.getShell(), container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
			dialog.open();
			Object[] result = dialog.getResult();

			if (result != null) {			
				if (result.length > 0) {

					Path container_path = (Path)result[0];
					URI savepath = URI.createPlatformResourceURI(container_path.toString().replaceFirst("platform:/resource/",""));

					container_text.setText(""+savepath);

					PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
					
					setDirty(true);
				}
			}
		}
	}
	
	public Control getControl() {
		return mainpanel;
	}
	
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute("host_rac","localhost");
		configuration.setAttribute("smodel_container","platform:/resource/"+PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT"));
		configuration.setAttribute("monitor",PerfmonPlugin.getString("DEFAULT_MONITOR"));

		try {
			IWorkspace workspace = ResourcesPlugin.getWorkspace();
			String s = URI.createPlatformResourceURI(workspace.getRoot().getProjects()[0].getFullPath().toString()).toString();
			configuration.setAttribute("smodel_container",s);
		} catch (Exception e) {
			PerfmonPlugin.DBG.error("problem getting default project",e);
		}
		configuration.setAttribute("statcon_file","");

		checkForErrors();
}
	
	public void initializeFrom(ILaunchConfiguration configuration) {
		setDirty(false);
		try {
			rac_host_text.setText(configuration.getAttribute("host_rac","localhost"));
			container_text.setText(configuration.getAttribute("smodel_container","platform:/resource/"+PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT")));
			monitor_text.setText(configuration.getAttribute("monitor",PerfmonPlugin.getString("DEFAULT_MONITOR")));
		} catch (CoreException e) {
			PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_LAUNCH_CONFIG"),true);
		}
		
		checkForErrors();
	}
	
	public void dispose() {
		try {
			mainpanel.dispose();
		} catch (Throwable t) {
		}
	}
	
	private void printConfiguration(ILaunchConfiguration conf) {
		try {

			PerfmonPlugin.DBG.info(conf.getAttribute("host_rac","localhost"));
			PerfmonPlugin.DBG.info(conf.getAttribute("smodel_container",""));
			PerfmonPlugin.DBG.info(conf.getAttribute("monitor",PerfmonPlugin.getString("DEFAULT_MONITOR")));
			PerfmonPlugin.DBG.info(conf.getAttribute("statcon_file",""));

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		printConfiguration(configuration);
		configuration.setAttribute("host_rac",rac_host_text.getText());
		configuration.setAttribute("smodel_container",container_text.getText());
		configuration.setAttribute("monitor",monitor_text.getText());
	}

	public void checkForErrors() {
		error_message = "";
		try {
			if (rac_host_text.getText().length() == 0) {
				error_message = PerfmonPlugin.getString("BAD_RAC_HOST");
			}
			if (container_text.getText().length() == 0) {
				error_message = PerfmonPlugin.getString("BAD_CONTAINER");
			}
			if (monitor_text.getText().length() == 0) {
				error_message = PerfmonPlugin.getString("BAD_MONITOR");
			}
		} catch (Exception e) {			
		}
		setError(error_message);
		updateLaunchConfigurationDialog();
	}
	
	public String getErrorMessage() {
		return error_message;
	}
	
	public String getMessage() {
		return message;
	}
	
	public boolean isValid(ILaunchConfiguration launchConfig) {
		return error_message == null;
	}
	
	public boolean canSave() {
		return isdirty;
	}

	protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
		return dialog;
	}	
	public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
		this.dialog = dialog;
	}
	
	public void launched(ILaunch launch) {
	}
	
	public String getName() {
		return PerfmonPlugin.getString("LINUX_AGENT");
	}
	
	public Image getImage() {
		return PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_LOGO);
	}
	
	public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
		initializeFrom(workingCopy);
	}
	
	public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
		performApply(workingCopy);
	}
}