/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SecurityPlugin extends AbstractUIPlugin
{
	private final static String KEYSTORE = "keystore.dat";
	private static SecurityPlugin inst;
	private static ResourceBundle aResourceBundle;

	public SecurityPlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		//**** cash the Plugin and the resource bundle instances
		if (inst == null)
			inst = this;
		aResourceBundle = this.getDescriptor().getResourceBundle();
	}
	public static SecurityPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}

	public static ResourceBundle getResourceBundle() {
		return aResourceBundle;
	}
	public static String getResourceString(String key) {
		ResourceBundle bundle = SecurityPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	public static String getKeyStoreLocation() {
		
		return Platform.getPluginStateLocation(inst).append(KEYSTORE).toOSString();
	}

	public static String getWorkspaceName(){
		IPath workspace = Platform.getLocation();
		int nr = workspace.segmentCount();
		String workspaceName = workspaceName = workspace.segment(nr - 1);
		return workspaceName;		
	}

	public void shutdown() throws CoreException {

		SecurityImages.shutdown();

		super.shutdown();
	}

	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}
}
