package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Association Engine</b></em>'.
 * <p>
 * The AssociationEngine identifies the application that establishes 
 * associations among related or associated events.  In addition, it provides 
 * properties to describe the types of the associations.  
 * <p>
 * The AssociationEngine is a standalone entity in the XML schema and the 
 * AssociatedEvents created by the application that is identified by the 
 * AssociationEngine refer to it.  This will eliminate the need to repeat 
 * the same data in every associated event.
 * <p>
 * Upon object creation and/or initialization (e.g. <code>init()</code>), a 
 * new unique <code>GUID</code> is assigned to the <code>id</code> 
 * property.
 * <p>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0 
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociationEngine()
 * @model 
 * @generated
 */
public interface AssociationEngine extends EObject, Serializable {

    /**
     * <P>
     * Value for the <em><b>Type</b></em> attribute.
     * </P>
     * <P>
     * The association represents containment of other events within a 
     * root event.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CONTAIN = "Contain";

    /**
     * <P>
     * Value for the <em><b>Type</b></em> attribute.
     * </P>
     * <P>
     * The association represents a causality allowing the associated event to 
     * point to the cause of the situation.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CAUSED_BY = "CausedBy";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a relationship where an event points to an 
     * event that fixes or results in the situation becoming irrelevant.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CLEARED = "Cleared";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a collection of events together compose a 
     * single event.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_MULTI_PART = "MultiPart";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a relationship between a child and parent 
     * event based on a correlation algorithm specified in the name of the 
     * association.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CORRELATED = "Correlated";

    /**
     * <P>
     * Returns the value of the '<em><b>Id</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Id</em>' attribute.
     * @see #setId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociationEngine_Id()
     * @model id="true" required="true"
     * @generated
     */
    String getId();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getId <em>Id</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * The primary identifier for the element. This property <em>must</em> be globally 
     * unique.  The recommend value for this is either a 128 bit or 256 bit 
     * Globally Unique Id (represented as hex string).  Once this value is set 
     * it <em>must</em> never be changed.  This is a <em>required</em> property.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Id</em>' attribute.
     * @see #getId()
     * @generated
     */
    void setId(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociationEngine_Type()
     * @model required="true"
     * @generated
     */
    String getType();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getType <em>Type</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * This property should contain the type of association created by this 
     * AssociationEngine.  Some well defined associations are:
     * <UL>
     * <LI>Contains</LI>
     * <LI>Cleared</LI>
     * <LI>CausedBy</LI>
     * <LI>MultiPart</LI>
     * <LI>Correlated
     * </UL>
     * </P>
     * <P>
     * This is a <em>required</em> property.  The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     * @generated
     */
    void setType(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociationEngine_Name()
     * @model required="true"
     * @generated
     */
    String getName();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getName <em>Name</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * The name of the application that creates the association (for example, my 
     * correlation engine name).  This is a <em>required</em> property.  
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
    void setName(String value);

    /**
     * </P>
     * Checks whether the contents of this object conforms to the CBE specification.
     * </P>
     *
     * @throws ValidationException 
     *                       if the object does not follow the CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state, except the <code>id</code> property.
     * <p>
     * This API assigns a new unique <code>GUID</code> to the <code>id</code> property.
     * <p>
     * 
     * @since 1.0
     */
	void init();
} // AssociationEngine
