package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Validation exception used to indicate that a mandatory property,
 * according to the CBE specification, is not present within a class 
 * representing an element of that specification.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class MissingPropertyException extends ValidationException {

    /**
     * Simple constructor. 
     */
    public MissingPropertyException() {
        super();
    }

    /**
     * Constructs a <code>MissingPropertyException</code> with the specified 
     * detail message.
     * 
     * @param msg            the detail message
     */
    public MissingPropertyException(String msg) {
        super(msg);
    }

    /**
     * Constructs a <code>MissingPropertyException</code> with the specified 
     * detail message and a nested exception.
     * 
     * @param msg            the detail message
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public MissingPropertyException(String msg, Throwable cause) {
        super(msg,cause);
    }
    
    /**
     * Creates a <code>MissingPropertyException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     */
    public MissingPropertyException(String key, String file) {
        super(key, file, null);
    }

    /**
     * Creates a <code>MissingPropertyException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     * @param parms An array of elements to be inserted into the message.
     */
    public MissingPropertyException(String key, String file, Object[] parms) {
        super(key, file, parms);
    }

    /**
     * Creates a <code>MissingPropertyException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions) and a nested exception.
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     * @param parms An array of elements to be inserted into the message.
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public MissingPropertyException(String key, String file, Object[] parms, Throwable cause) {
        super(key, file, parms, cause);
    }
}
