package org.eclipse.hyades.logging.events.cbe.impl;

import java.util.StringTokenizer;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Associated Event</b></em>'.
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AssociatedEventImpl#getAssociationEngine <em>Association Engine</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AssociatedEventImpl#getResolvedEvents <em>Resolved Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AssociatedEventImpl#getAssociationEngineInfo <em>Association Engine Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AssociatedEventImpl extends SerializableImpl implements AssociatedEvent, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -4327879421885580788L;

    /**
     * Classname for trace/log
     */
    private static final String CLASS_NAME = AssociatedEventImpl.class.getName();

    /**
     * The default value of the '{@link #getAssociationEngine() <em>Association Engine</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAssociationEngine()
     * @generated
     * @ordered
     */
    protected static final String ASSOCIATION_ENGINE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getAssociationEngine() <em>Association Engine</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAssociationEngine()
     * @generated
     * @ordered
     */
    protected String associationEngine = ASSOCIATION_ENGINE_EDEFAULT;

    /**
     * The default value of the '{@link #getResolvedEvents() <em>Resolved Events</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResolvedEvents()
     * @generated
     * @ordered
     */
    protected static final String RESOLVED_EVENTS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getResolvedEvents() <em>Resolved Events</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResolvedEvents()
     * @generated
     * @ordered
     */
    protected String resolvedEvents = RESOLVED_EVENTS_EDEFAULT;

    /**
     * The cached value of the '{@link #getAssociationEngineInfo() <em>Association Engine Info</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAssociationEngineInfo()
     * @generated
     * @ordered
     */
    protected AssociationEngine associationEngineInfo = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AssociatedEventImpl() {
        super();       
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setAssociationEngine(String newAssociationEngine) {
        String oldAssociationEngine = associationEngine;
        associationEngine = newAssociationEngine;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE, oldAssociationEngine, associationEngine));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getAssociationEngine() {
        return associationEngine;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setAssociationEngineInfo(AssociationEngine newAssociationEngineInfo) {
        if (newAssociationEngineInfo != associationEngineInfo) {
            NotificationChain msgs = null;
            if (associationEngineInfo != null)
                msgs = ((InternalEObject) associationEngineInfo).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO, null, msgs);
            if (newAssociationEngineInfo != null)
                msgs = ((InternalEObject) newAssociationEngineInfo).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO, null, msgs);
            msgs = basicSetAssociationEngineInfo(newAssociationEngineInfo, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO, newAssociationEngineInfo, newAssociationEngineInfo));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent#setAssociationEngineInfo(String, String, String)
     */
    public void setAssociationEngineInfo(String associationEngineName, String associationEngineType, String associationEngineId) {
        AssociationEngine aei = EventFactory.eINSTANCE.createAssociationEngine();
        aei.setName(associationEngineName);
        aei.setType(associationEngineType);
        aei.setId(associationEngineId);

        setAssociationEngineInfo(aei);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public AssociationEngine getAssociationEngineInfo() {
        return associationEngineInfo;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setResolvedEvents(String newResolvedEvents) {
        String oldResolvedEvents = resolvedEvents;
        resolvedEvents = newResolvedEvents;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.ASSOCIATED_EVENT__RESOLVED_EVENTS, oldResolvedEvents, resolvedEvents));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getResolvedEvents() {
        return resolvedEvents;
    }

    /**
     * This routine will take a string array and build a blank delimited list
     * from each element of the list.  Blanks in the array elements would
     * cause problems in parsing the list.  Therefore, an IllegalArgumentException
     * will be thrown if any array element contains blanks. 
     */
    public void setResolvedEventsAsArray(String[] newResolvedEvents) {
        // need to check that each element of the string array contains no blanks   
        StringBuffer myList = new StringBuffer();

        if (newResolvedEvents != null) {
            for (int i = 0; i < newResolvedEvents.length; i++) {
                if (newResolvedEvents[i].indexOf(" ") != -1) {
                    throw new IllegalArgumentException("Blanks are not allowed in the array [" + newResolvedEvents[i] + "]");
                }

                if (i != 0) {
                    myList.append(" ");
                }
                myList.append(newResolvedEvents[i]);
            }
        }
        else {
            throw new IllegalArgumentException("The input array cannot be null.");
        } // if parameter not null

        setResolvedEvents(myList.toString());
    }

    /**
     *
     */
    public String[] getResolvedEventsAsArray() {
        String myList = getResolvedEvents();
        int arrayElem = 0;
        StringTokenizer myParser = null;

        if (myList == null) {
            arrayElem = 0;
        }
        else {
            myParser = new StringTokenizer(myList);
            arrayElem = myParser.countTokens();
        }

        String[] myArray = new String[arrayElem];

        if (arrayElem > 0) {
            for (int i = 0; myParser.hasMoreTokens(); i++) {
                myArray[i] = myParser.nextToken();
            }
        }

        return myArray;
    }

    /**
     * Adds a Common Base Event reference to the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The new Common Base Event globalInstanceId.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @since 1.0
     */
    public void addResolvedEvent(String globalInstanceId) {

        if (globalInstanceId != null) {

            if (resolvedEvents == RESOLVED_EVENTS_EDEFAULT) {
                setResolvedEvents(globalInstanceId);
            }
            //Do not persist duplicates:
            else if (resolvedEvents.indexOf(globalInstanceId) == -1) {
                setResolvedEvents(resolvedEvents.trim().concat(" ").concat(globalInstanceId.trim()));
            }
        }
        else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    /**
     * Removes all Common Base Event references in the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @since 1.0
     */
    public void clearResolvedEvents() {
        resolvedEvents = RESOLVED_EVENTS_EDEFAULT;
    }

    /**
     * Removes a named Common Base Event reference in the array of resolved events.
     *     
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The removed Common Base Event globalInstanceId.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @since 1.0
     */
    public void removeResolvedEvent(String globalInstanceId) {

        if (globalInstanceId != null) {

            if (resolvedEvents != RESOLVED_EVENTS_EDEFAULT) {

                int index;
                
                //Remove any duplicates:
                while((index = resolvedEvents.indexOf(globalInstanceId)) != -1){
                    setResolvedEvents(resolvedEvents.substring(0,index).trim().concat(" ").concat(resolvedEvents.substring(index + globalInstanceId.length()).trim()));
                }
            }
        }
        else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetAssociationEngineInfo(AssociationEngine newAssociationEngineInfo, NotificationChain msgs) {
        AssociationEngine oldAssociationEngineInfo = associationEngineInfo;
        associationEngineInfo = newAssociationEngineInfo;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO, oldAssociationEngineInfo, newAssociationEngineInfo);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE :
                return getAssociationEngine();
            case EventPackage.ASSOCIATED_EVENT__RESOLVED_EVENTS :
                return getResolvedEvents();
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO :
                return getAssociationEngineInfo();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO :
                    return basicSetAssociationEngineInfo(null, msgs);
                default :
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE :
                return ASSOCIATION_ENGINE_EDEFAULT == null ? associationEngine != null : !ASSOCIATION_ENGINE_EDEFAULT.equals(associationEngine);
            case EventPackage.ASSOCIATED_EVENT__RESOLVED_EVENTS :
                return RESOLVED_EVENTS_EDEFAULT == null ? resolvedEvents != null : !RESOLVED_EVENTS_EDEFAULT.equals(resolvedEvents);
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO :
                return associationEngineInfo != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE :
                setAssociationEngine((String) newValue);
                return;
            case EventPackage.ASSOCIATED_EVENT__RESOLVED_EVENTS :
                setResolvedEvents((String) newValue);
                return;
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO :
                setAssociationEngineInfo((AssociationEngine) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE :
                setAssociationEngine(ASSOCIATION_ENGINE_EDEFAULT);
                return;
            case EventPackage.ASSOCIATED_EVENT__RESOLVED_EVENTS :
                setResolvedEvents(RESOLVED_EVENTS_EDEFAULT);
                return;
            case EventPackage.ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO :
                setAssociationEngineInfo((AssociationEngine) null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {

        synchronized(this){
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {

        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (associationEngine: ");
        result.append(associationEngine);
        result.append(", resolvedEvents: ");
        result.append(resolvedEvents);
        result.append(", associationEngineInfo: ");        
        result.append(associationEngineInfo);
        result.append(')');                
        return result.toString();
    }
    
    /**
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     *
     * @throws ValidationException
     *                       if the object does not follow the
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){
	
	        // checking for required attributes
	        EventValidation.validateRequiredProperties(CLASS_NAME, this);
	
	        EAttribute attE = EventPackage.eINSTANCE.getAssociatedEvent_AssociationEngine();
	        EAttribute attR = EventPackage.eINSTANCE.getAssociatedEvent_ResolvedEvents();
	        EReference attI = EventPackage.eINSTANCE.getAssociatedEvent_AssociationEngineInfo();
	
	        // checking for mutually exclusive attributes
	        EventValidation.validateMutuallyExclusiveAttributes(CLASS_NAME, this, attI, attE);
	
	        // checking resolvedEvents
	        EventValidation.validateStringIdList(CLASS_NAME, this, attR);
	
	        // checking for boundaries
	        EventValidation.validateLength(CLASS_NAME, this, attE, 32, 64);
	
	        // checking associationEngineInfo
	        if (getAssociationEngineInfo() != null) {
	            getAssociationEngineInfo().validate();
	        }
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getAssociatedEvent();
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setAssociationEngine(ASSOCIATION_ENGINE_EDEFAULT);
        setAssociationEngineInfo(null);
        setResolvedEvents(RESOLVED_EVENTS_EDEFAULT);
    }
}
//AssociatedEventImpl
